function list = nonunique(list)
% nonunique  Non-unique entries in a list.
%
% Syntax
% =======
%
%     B = nonunique(A)
%
% Input arguments
% ================
%
% * `A` [ cellstr ] - Input list of strings that will be checked for
% non-unique entries.
%
% Output arguments
% =================
%
% * `B` [ cellstr ] - Output list of non-unique entries.
%
% Description
% ============
%
% Example
% ========
%

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

[ans,index] = unique(list); %#ok<NOANS,ASGLU>
list(index) = [];
if ~isempty(list)
    list = unique(list);
end

end