function [LIST,LAB] = labexpr(LIST)
% labexpr  [Not a public function] Parse labeled expressions.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

retchar = ischar(LIST);
if retchar
    LIST = {LIST};
end

%**************************************************************************

nlist = length(LIST);
LAB = cell(1,nlist);
LAB(:) = {''};

LIST = strtrim(LIST);

for i = 1 : nlist
    [lab,to] = regexp(LIST{i},'([''"]).*?\1','match','end','once');
    if ~isempty(lab)
        LAB{i} = lab(2:end-1);
        LIST{i}(1:to) = '';
        LIST{i} = strtrim(LIST{i});
    end
end

if retchar
    LIST = LIST{1};
    LAB = LAB{1};
end

end