classdef vline < report.annotateobj
% vline  Add vertical line to graph.
%
% Syntax
% =======
%
%     P.vline(CAP,DATE,...)
%
% Input arguments
% ================
%
% * `P` [ struct ] - Report object created by the
% [`report.new`](report/new) function.
%
% * `CAP` [ char ] - Caption used to annotate the vertical line.
%
% * `DATE` [ numeric ] - Date at which the vertical line will be plotted.
%
% Options
% ========
%
% * `'hPosition='` [ `'bottom'` | `'middle'` | *`'top'`* ] - (Inheritable from
% parent objects) Horizontal position of the caption.
%
% * `'vPosition='` [ `'centre'` | `'left'` | *`'right'`* ] - (Inheritable from
% parent objects) Vertical position of the caption relative to the line.
%
% * `'timePosition='` [ `'after'` | `'before'` | `'middle'` ] - Placement of the
% vertical line on the time axis: in the middle of the specified period,
% immediately before it (between the specified period and the previous
% one), or immediately after it (between the specified period and the next
% one).
%
% Generic options
% ================
%
% See help on [generic options](report/Contents) in report objects.
%
% Description
% ============
%
% Example
% ========
%

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.
    
    methods
        function this = vline(varargin)
            this = this@report.annotateobj(varargin{:});
        end
        
        function plot(this,ax)
            if isempty(this.location) || ~isnumeric(this.location)
                return
            end
            grfun.vline(ax,this.location, ...
                'caption',this.caption, ...
                'vPosition',this.options.vposition, ...
                'hPosition',this.options.hposition, ...
                'timePosition',this.options.timeposition);
        end
        
    end
    
end