classdef tex < report.userinputobj
    % tex  Include \LaTeX\ code or verbatim text input in report.
    %
    % Syntax with input specified in comment block
    % =============================================
    %
    %     P.tex(CAP,...)
    %
    %     %{
    %     Write text or \LaTeX\ code as a block comment
    %     right after the p.text(...) command.
    %     %}
    %
    % Syntax with input specified as char argument
    % =============================================
    %
    %     P.tex(CAP,CODE,...)
    %
    % Input arguments
    % ================
    %
    % * `P` [ struct ] - Report object created by the [`report.new`](report/new)
    % function.
    %
    % * `CAP` [ char ] - Caption displayed at the top of the text.
    %
    % * `CODE` [ char ] - \LaTeX\ code or text input that will be included in the
    % report.
    %
    % Options
    % ========
    %
    % * `'centering='` [ `true` | *`false`* ] - (Inheritable from parent objects)
    % Centre the \LaTeX\ code or text input on the page.
    %
    % * `'footnote='` [ char | *empty* ] - Footnote at the tex block title; only
    % shows if the title is non-empty.
    %
    % * `'separator='` [ char | *`'\medskip\par'`* ] - (Inheritable from parent
    % objects) LaTeX commands that will be inserted after the text.
    %
    % * `'verbatim='` [ `true` | *`false`* ] - If true the text will be typeset
    % verbatim in monospaced font; if false the text will be treated as \LaTeX\ 
    % code included in the report.
    %
    % Generic options
    % ================
    %
    % See help on [generic options](report/Contents) in report objects.
    %
    % Description
    % ============
    %
    % Example
    % ========
    %
    
    % -IRIS Toolbox.
    % -Copyright (c) 2007-2012 Jaromir Benes.
    
    properties
    end
    
    methods
        
        function THIS = tex(varargin)
            THIS = THIS@report.userinputobj(varargin{:});
            THIS.default = [THIS.default,{ ...
                'separator','\medskip\par',@ischar,true, ...
                'verbatim',false,@islogicalscalar,true, ...
                }];
        end
        
        function [this,varargin] = specargin(this,varargin)
            % If the number of input arguments behind `CAP` is odd and the first input
            % argument after `cap` is char, we grab it as input code/text; otherwise we
            % grab the comment block from caller.
            if mod(length(varargin),2) == 1 && ischar(varargin{1})
                this.userinput = varargin{1};
                varargin(1) = [];
            else
                caller = dbstack('-completenames');
                if length(caller) >= 4
                    this.userinput = strfun.grabcommentblock(caller(4));
                end
            end
        end
        
        function [C,TEMPS] = speclatexcode(THIS)
            [C,TEMPS] = speclatexcode@report.userinputobj(THIS);
        end
        
    end
    
end