classdef section < report.genericobj
    % section  Start new section in report.
    %
    % Syntax
    % =======
    %
    %     p.section(CAP,...)
    %
    % Input arguments
    % ================
    %
    % * `P` [ struct ] - Report object created by the
    % [`report.new`](report/new) function.
    %
    % * `CAP` [ char ] - Section title.
    %
    % Options
    % ========
    %
    % * `'numbered='` [ *`true`* | `false` ] - (Inheritable from parent objects)
    % Numbered section.
    %
    % * `'separator='` [ char | *empty* ] - (Not inheritable from parent
    % objects) \LaTeX\ commands that will be inserted after the table.
    %
    % Generic options
    % ================
    %
    % See help on [generic options](report/Contents) in report objects.
    %
    % Description
    % ============
    %
    % Example
    % ========
    %
    
    % -IRIS Toolbox.
    % -Copyright (c) 2007-2012 Jaromir Benes.
    
    methods
        
        function THIS = section(varargin)
            THIS = THIS@report.genericobj(varargin{:});
            THIS.childof = {'report'};
            THIS.default = [THIS.default,{ ...
                'numbered',true,@islogical,true,...
                'separator','',@ischar,false,...
                }];
        end
        
        function [THIS,varargin] = specargin(THIS,varargin)
        end
        
        function [C,TEMPFILES] = speclatexcode(THIS)
            TEMPFILES = {};
            if isempty(THIS.caption)
                C = '';
                return
            end
            if THIS.options.numbered
                numbered = '';
            else
                numbered = '*';
            end
            C = ['\section',numbered,'{',...
                latex.stringsubs(THIS.caption),'}'];
        end
        
    end
    
end