function this = new(varargin)
% new  New report object.
%
% Syntax
% =======
%
%     x = report.new(CAP,...)
%
% Output arguments
% =================
%
% * `x` [ struct ] - Report object with function handles through wich
% the individual report elements can be created.
%
% * `CAP` [ char ] - Report caption; the caption will also be printed on
% the title page of the report if published with the option `'makeTitle='`
% `true`.
%
% Options
% ========
%
% * `'centering='` [ *`true`* | `false` ] - All report elements, except
% [`tex`](report/tex), will be centered on the page.
%
% * `'orientation='` [ *`'landscape'`* | '`portrait`' ] - Paper orientation
% of the published report.
%
% Report options are cascading. You can specify any of an object's options
% in any of his parent (or ascendant) objects.
%

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

this = report.report(varargin{:});
[this,varargin] = specargin(this,varargin{2:end});
this = setoptions(this,this.default,struct(),varargin{:});

end

