classdef include < report.userinputobj
    % include  Include text or LaTeX input file in the report.
    %
    % Syntax
    % =======
    %
    %     P.include(CAP,FNAME,...)
    %
    % Input arguments
    % ================
    %
    % * `P` [ struct ] - Report object created by the
    % [`report.new`](report/new) function.
    %
    % * `CAP` [ char ] - Caption displayed at the top of the file included.
    %
    % * `FNAME` [ char ] - File name that will be included here.
    %
    % Options
    % ========
    %
    % * `'centering='` [ `true` | *`false`* ] - (Inheritable from parent objects)
    % Centre the content of the file on the page.
    %
    % * `'separator='` [ char | *empty* ] - (Not inheritable from parent
    % objects) \LaTeX\ commands that will be inserted after the table.
    %
    % * `'typeface='` [ char | *empty* ] - (Not inheritable from parent objects)
    % \LaTeX\ code specifying the typeface for the include element as a whole; it
    % must use the declarative forms (such as `\itshape`) and not the command
    % forms (such as `\textit{...}`).
    %
    % * `'verbatim='` [ `true` | *`false`* ] - (Not inheritable from parent objects)
    % Enclose the content of the file in a verbatim environment.
    %
    % Generic options
    % ================
    %
    % See help on [generic options](report/Contents) in report objects.
    %
    % Description
    % ============
    %
    % Example
    % ========
    %
    
    % -IRIS Toolbox.
    % -Copyright (c) 2007-2012 Jaromir Benes.
    
    properties
        filename = '';
    end
    
    methods
        
        function this = include(varargin)
            this = this@report.userinputobj(varargin{:});
            this.default = [this.default,{ ...
                'lines',Inf,@isnumeric,true, ...
                'separator','\medskip\par',@ischar,false, ...
                'typeface','',@ischar,false, ...                
                }];
        end
        
        function [this,varargin] = specargin(this,varargin)
            if ~isempty(varargin)
                this.filename = varargin{1};
                varargin(1) = [];
            end
        end
        
        function [C,TEMPS] = speclatexcode(THIS)
            THIS.userinput = ...
                file2char(THIS.filename,'char',THIS.options.lines);
            THIS.userinput = strfun.converteols(THIS.userinput);
            [C,TEMPS] = speclatexcode@report.userinputobj(THIS);
        end
        
    end
    
end