classdef highlight < report.annotateobj
% highlight  Highlight range in graph.
%
% Syntax
% =======
%
%     P.highlight(CAP,RANGE,...)
%
% Input arguments
% ================
%
% * `P` [ struct ] - Report object created by the
% [`report.new`](report/new) function.
%
% * `CAP` [ char ] - Caption used to annotate the highlighted area.
%
% * `RANGE` [ cell | numeric ] - Date range, or a cell array of ranges,
% that will be highlighted.
%
% Options
% ========
%
% * `'hPosition='` [ `'bottom'` | `'middle'` | *`'top'`* ] - (Inheritable from
% parent objects) Horizontal position of the caption.
%
% * `'vPosition='` [ `'centre'` | `'left'` | *`'right'`* ] - (Inheritable from
% parent objects) Vertical position of the caption relative to the edges of
% the highlighted area.
%
% Generic options
% ================
%
% See help on [generic options](report/Contents) in report objects.
%
% Description
% ============
%
% Example
% ========
%

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.
    
    methods
        function this = highlight(varargin)
            this = this@report.annotateobj(varargin{:});
        end
        
        function plot(this,ax)
            x = this.location;
            if isempty(this.location) ...
                    || ~(isnumeric(x) || (iscell(x) && all(cellfun(@isnumeric,x))))
                return
            end
            grfun.highlight(ax,this.location, ...
                'caption',this.caption, ...
                'vPosition',this.options.vposition, ...
                'hPosition',this.options.hposition);
        end
        
    end
    
end