classdef empty < report.genericobj
% empty  Empty report object.
%
% Syntax
% =======
%
%     P.empty()
%
% Input arguments
% ================
%
% * `P` [ struct ] - Report object created by the
% [`report.new`](report/new) function.
%
% Generic options
% ================
%
% See help on [generic options](report/Contents) in report objects.
%
% Description
% ============
%
% The `empty` object does not produce any visible output in the report. It
% can be used in [`align`](report/align) or [`figure`](report/figure) to
% create blank space.
%
% Example
% ========
%

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

   methods

      function this = empty(varargin)
         this = this@report.genericobj(varargin{:});
         this.childof = {'report','align','figure'};
         this.default = [this.default,{}];
      end
      
      function [this,varargin] = specargin(this,varargin)
      end
      
      function THIS = setoptions(THIS,varargin)
          THIS = setoptions@report.genericobj(THIS,varargin{:});
          THIS.options.typeface = '';
      end
      
      function [c,helperfiles] = speclatexcode(this) %#ok<MANU>
         helperfiles = {};
         c = '';
      end
      
      % The methods `plot` and `subplot` are called from within figure. Do
      % nothing, and let the subplot position counter move to the next one.
      function plot(THIS,varargin) %#ok<MANU>
      end
      
      function AX = subplot(THIS,varargin) %#ok<MANU>
         AX = [];
      end
      
   end
   
end