classdef condformatobj < handle
% condformatobj  [Not a public class] Conditional format object.
%
% Backend IRIS class.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.
    
    properties
        test = {};
        format = {};
    end
    
    properties (Constant)
        attribute = { ...
            'value', ...
            'text', ...
            'mark', ...
            'date', ...
            'year', ...
            'period', ...
            'freq', ...
            'rowname', ...
            'colname', ...
            'row', ...
            'col', ...
            'rowvalues', ...
            'colvalues', ...
            'allvalues', ...
            };
    end
    
    methods
        
        function THIS = condformatobj(varargin)
        end
        
        function THIS = assign(THIS,OPT)
            if ~isempty(OPT)
                THIS.test = {OPT.test};
                THIS.format = {OPT.format};
                temp = sprintf('%s,',THIS.attribute{:});
                temp(end) = '';
                for i = 1 : length(THIS.test)
                    try
                        THIS.test{i} = ...
                            str2func(['@(',temp,')',THIS.test{i}]);
                    catch %#ok<CTCH>
                        THIS.test{i} = str2func('@(varargin) false');
                    end
                end
            end
        end
        
        function C = testnformat(THIS,C,A)
            if isempty(THIS.format)
                return
            end
            args = inputargs(THIS,A);
            ntest = length(THIS.format);
            passed = false(1,ntest);
            for i = 1 : ntest
                try %#ok<TRYNC>
                    passed(i) = THIS.test{i}(args{:});
                end
            end
            if any(passed)
                for i = find(passed)
                    % Format may or may not have a reference to the
                    % current string, ?. If the reference is not there,
                    % put the current format before the current string.
                    if ~isempty(strfind(THIS.format{i},'?'))
                        C = strrep(THIS.format{i},'?',C);
                    else
                        C = [THIS.format{i},' ',C]; %#ok<AGROW>
                    end
                    %C = strrep(C,'\ensuremath','');
                    C = ['\ensuremath{',C,'}']; %#ok<AGROW>
                end
            end
        end
        
        function ARGS = inputargs(THIS,A)
            n = length(THIS.attribute);
            ARGS = cell(1,n);
            for i = 1 : n
                if isfield(A,THIS.attribute{i})
                    ARGS{i} = A.(THIS.attribute{i});
                else
                    ARGS{i} = NaN;
                end
            end
        end
        
    end
    
end