% report  Report objects and functions.
%
% New report
% ===========
%
% * [`new`](report/new) - New report object.
% * [`copy`](report/copy) - Create a copy of a report object.
%
% Compiling PDF report
% =====================
%
% * [`publish`](report/publish) - Compile PDF from report object.
%
% Top-level objects
% ==================
%
% * [`table`](report/table) - Start new table in report.
% * [`figure`](report/figure) - Start new figure in report.
% * [`matrix`](report/matrix) - Insert matrix, or numeric array, in report.
% * [`modelfile`](report/modelfile) - Write formatted model file in report.
% * [`array`](report/array) - Insert an array with user data in report.
% * [`tex`](report/tex) - Include \LaTeX\ code or verbatim text input in report.
%
% Figure objects
% ===============
%
% * [`graph`](report/graph) - Add graph to figure.
%
% Table and graph objects
% ========================
%
% * [`band`](report/band) - Add new data with lower and upper bounds to graph or table.
% * [`fanchart`](report/fanchart) - Add fancharts to graphs.
% * [`series`](report/series) - Add new data to graph or table.
% * [`subheading`](report/subheading) - Enter subheading in table.
% * [`vline`](report/vline) - Add vertical line to graph.
% * [`highlight`](report/highlight) - Highlight range in graph.
%
% Structuring reports
% ====================
%
% * [`align`](report/align) - Vertically align the following K objects.
% * [`empty`](report/empty) - Empty report object.
% * [`include`](report/include) - Include text or LaTeX input file in the report.
% * [`merge`](report/merge) - Merge the content of two or more report objects.
% * [`pagebreak`](report/pagebreak) - Force page break.
% * [`section`](report/section) - Start new section in report.
%
% Getting on-line help on report functions
% =========================================
%
%     help report
%     help report/function_name
%
% Generic options
% ================
%
% The following generic options can be used on any of the report objects.
%
% * `'saveAs='` [ char | *empty* ] - (Not inheritable from parent objects)
% Save the LaTeX code generated for the respective report element in a text
% file under the specified name.
%

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

