function [C,TEMPFILES] = speclatexcode(THIS)
% HEADLINE  [Not a public function] Latex code for table object.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

TEMPFILES = {};

br = sprintf('\n');

if isempty(THIS.options.range)
    caption = THIS.title;
    if isempty(caption)
        caption = 'unnamed table';
    end
    utils.warning('report', ...
        ['Empty range in table ''%s''. ', ...
        'No table will be produced.'], ...
        caption);
    return
end

% Start the tabular environment.
THIS.ncol = length(THIS.options.range);
THIS.options.colspec = colspec(THIS);
C = begin(THIS);

% Create headline.
C = [C,br,'\hline',br, ...
    headline(THIS), ...
    '\\',br,'\hline',br];

% If this is a long table (with the latex longtable package used), mark the
% end of headlines.
if THIS.options.long
    C = [C,'\endhead',br];
end

% Cycle over children and create table rows.
nchild = length(THIS.children);
for i = 1 : nchild
    c1 = latexcode(THIS.children{i});
    C = [C,c1]; %#ok<AGROW>
    if isfield(THIS.children{i}.options,'separator') ...
            && ~isempty(THIS.children{i}.options.separator)
        C = [C,br,THIS.children{i}.options.separator]; %#ok<AGROW>
    end
    C = [C,br]; %#ok<AGROW>
end

C = [C,finish(THIS)];
C = [C,footnotetext(THIS)];

end