function C = headline(THIS)
% HEADLINE  [Not a public function] Latex code for table headline.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

isdates = isempty(THIS.options.colstruct);
if isdates
    range = THIS.options.range;
else
    ncol = length(THIS.options.colstruct);
    range = 1 : ncol;
end

dateformat = THIS.options.dateformat;
nlead = THIS.nlead;
vline = THIS.vline;

br = sprintf('\n');

if isdates
    yearfmt = dateformat{1};
    currentfmt = dateformat{2};
    twolines = isdates && ~isequalwithequalnans(yearfmt,NaN);
else
    twolines = false;
    for i = 1 : ncol
        twolines = ...
            ~isequalwithequalnans(THIS.options.colstruct(i).name{1},NaN);
        if twolines
            break
        end
    end
end

leading = '&';
leading = leading(ones(1,nlead-1));
if isempty(range)
    if isnan(yearfmt)
        C = leading;
    else
        C = [leading,br,'\\',leading];
    end
    return
end
range = range(:).';
nper = length(range);
if isdates
    currentdates = dat2str(range,'dateformat',currentfmt);
    if ~isnan(yearfmt)
        yeardates = dat2str(range,'dateformat',yearfmt);
        yeardates = latex.stringsubs(yeardates);
    end
    currentdates = latex.stringsubs(currentdates);
    [year,per,freq] = dat2ypf(range); %#ok<ASGLU>
end

C = leading;
firstline = leading;
hrule = leading;
ycount = 0;

for i = 1 : nper
    ycount = ycount + 1;
    colw = THIS.options.colwidth(min(i,end));
    col = THIS.options.headlinejust;
    if i == 1 && any(vline == 0)
        col = ['|',col]; %#ok<AGROW>
    end
    if any(vline == i)
        col = [col,'|']; %#ok<AGROW>
    end
    if isdates
        secondlinetext = currentdates{i};
        if twolines
            firstlinetext = yeardates{i};
            firstlinechange = i == nper ...
                || year(i) ~= year(i+1) ...
                || freq(i) ~= freq(i+1);
        end
    else
        secondlinetext = THIS.options.colstruct(i).name{2};
        if twolines
            firstlinetext = THIS.options.colstruct(i).name{1};
            firstlinechange = i == nper ...
                || ~isequalwithequalnans( ...
                THIS.options.colstruct(i).name{1}, ...
                THIS.options.colstruct(i+1).name{1});
            if isequalwithequalnans(firstlinetext,NaN)
                firstlinetext = '';
            end
        end
    end
    % Second line.
    C = [C,'&\multicolumn{1}{',col,'}{', ...
        report.table.makebox(secondlinetext, ...
        '',colw,THIS.options.headlinejust,''), ...
        '}']; %#ok<AGROW>
    % Print the first line text across this and all previous columns that have
    % the same date/text on the first line.
    if twolines && firstlinechange
        command = [ ...
            '&\multicolumn{', ...
            sprintf('%g',ycount), ...
            '}{c}'];
        firstline = [firstline,command,'{', ...
            report.table.makebox(firstlinetext, ...
            '',NaN,'',''), ...
            '}']; %#ok<AGROW>
        hrule = [hrule,command]; %#ok<AGROW>
        if ~isempty(firstlinetext)
            hrule = [hrule,'{\hrulefill}']; %#ok<AGROW>
        else
            hrule = [hrule,'{}']; %#ok<AGROW>
        end
        ycount = 0;
    end
end
if twolines
    C = [firstline,'\\[-8pt]',br,hrule,'\\',br,C];
end

if iscellstr(C)
    C = [C{:}];
end

end