function C = latexonerow(THIS,ROW,TIME,DATA,MARK,TEXT)
% LATEXONEROW  [Not a public function] LaTeX code for one table series row.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

br = sprintf('\n');
nper = length(DATA);
markstring = latex.stringsubs(MARK);
C = [dolatexcaption(), ...
    footnotemark(THIS), ...
    ' & ',dolatexunits(), ...
    ' & ',markstring, ...
    latexdata(THIS,ROW,TIME,DATA,'',MARK,TEXT), ...
    ' \\'];

% Nested functions.

%**************************************************************************
    function C = dolatexcaption()
        if ROW == 1
            tit = latex.stringsubs(THIS.title);
            subtit = latex.stringsubs(THIS.subtitle);
            if isempty(subtit)
                C = tit;
                return
            end
            C = ['\multicolumn{3}{l}{',tit,'}', ...
                repmat(' &',1,nper),' \\',br];
            C = [C,subtit];
        else
            C = '';
        end
    end
% dolatexcaption().

%**************************************************************************
    function C = dolatexunits()
        if ROW == 1
            C = latex.stringsubs(THIS.options.units);
            C = ['~',C];
        else
            C = '';
        end
    end
% dolatexunits().

end
