function [OUTP,TIME] = getdata(THIS,INP,RANGE,COLSTRUCT)
% LATEXONEROW  [Not a public function] Evaluate data for report/series.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

ncol = length(RANGE);
if isempty(COLSTRUCT)
    dodates();
else
    docolstruct();
end

% Nested functions.

%**************************************************************************
    function dodates()
        % Table range can consist of dates with different frequencies.
        % For each frequency, find an input tseries with matching
        % frequency.
        if isequal(RANGE,Inf) || length(INP) == 1
            [OUTP,TIME] = INP{1}(RANGE,:);
            return
        end
        TIME = RANGE;
        
        rangefreq = datfreq(RANGE);
        datafreq = cellfun(@freq,INP);
        % We cannot pre-allocate `outp` properly because the number of
        % columns is unknown at this point.
        OUTP = [];
        for ii = [0,1,2,4,6,12]
            rangepos = rangefreq == ii;
            datapos = datafreq == ii;
            if any(rangepos) && any(datapos)
                datapos = find(datapos,1);
                thisrange = RANGE(rangepos);
                thisdata = INP{datapos}(thisrange,:);
                if isempty(OUTP)
                    OUTP = nan(ncol,size(thisdata,2));
                end
                OUTP(rangepos,:) = thisdata;
            end
        end
    end
% dodates().

%**************************************************************************
    function docolstruct()
        nrow = size(INP{1},2);
        OUTP = nan(ncol,nrow);
        TIME = 1 : ncol;
        for ii = 1 : ncol
            func = COLSTRUCT(ii).func;
            date = COLSTRUCT(ii).date;
            x = INP{1};
            if isa(func,'function_handle')
                x = func(x);
                if ~isa(x,'tseries') && ~isnumericscalar(x)
                    utils.error('report', ...
                        ['Function %s fails to evaluate to tseries or numeric scalar ', ...
                        'when applied to this series: ''%s''.'], ...
                        char(func),THIS.title);
                end
            end
            if isa(x,'tseries')
                x = x(date);
            end
            if ~isnumericscalar(x)
                if ~isa(x,'tseries') && ~isnumericscalar(x)
                    keyboard
                    utils.error('report', ...
                        ['Value in column #%g ', ...
                        'fails evalute to numeric scalar for this series: ''%s''.'], ...
                        ii,THIS.title);
                end
            end
            try %#ok<TRYNC>
                OUTP(ii,:) = x;
            end
        end
    end
% docolstruct().

end
