function [C,TEMPFILES] = speclatexcode(THIS)
% speclatexcode  [Not a public function] \LaTeX\ code for matrix object.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

TEMPFILES = {};
nl = sprintf('\n');
THIS.nlead = double(anyrowname(THIS));
% Start of tabular and tabular spec.
if isempty(THIS.options.colspec)
    THIS.options.colspec = colspec(THIS);
end
C = begin(THIS);
C = [C,nl,'\hline',nl];
% User-supplied heading.
if ~isempty(THIS.options.heading)
    C = [C,nl,THIS.options.heading];
end
% Column names rotated.
if anycolname(THIS)
    c1 = '';
    for i = 1 : THIS.ncol
        if i > 1
            c1 = [c1,' & ']; %#ok<AGROW>
        end
        c2 = latex.stringsubs(THIS.options.colnames{i});
        % Add a space when measuring the width of the string.
        if THIS.options.rotatecolnames
            c1 = [c1,report.tabularobj.turnbox(c2)]; %#ok<AGROW>
        else
            c1 = [c1,c2]; %#ok<AGROW>
        end
    end
    if THIS.nlead == 1
        c1 = [' & ',c1];
    end
    C = [C,c1,' \\',nl,'\hline',nl];
end
% Cycle over the matrix rows.
for i = 1 : THIS.nrow
    if THIS.nlead == 1
        C = [C,nl,'{',...
            latex.stringsubs(THIS.options.rownames{i}),...
            '}']; %#ok<AGROW>
    end
    % Cycle over the matrix columns.
    c1 = cell(1,THIS.ncol);
    for j = 1 : THIS.ncol
        c1{j} = ...
            report.matrix.sprintf(THIS.data(i,j),THIS.options);
        c1{j} = report.matrix.makebox(...
            c1{j},'',THIS.options.colwidth,'r','');
        a = doattributes();
        c1{j} = testnformat(THIS,c1{j},a);
    end
    for j = 1 : THIS.ncol
        if THIS.nlead == 1 || j > 1
            C = [C,' & ']; %#ok<AGROW>
        end
        C = [C,c1{j}]; %#ok<AGROW>
    end
    C = [C,' \\']; %#ok<AGROW>
end

% Finish all environments.
C = [C,nl,finish(THIS)];

% Nested functions.

%**************************************************************************
    function a = doattributes()
        % doattributes  Prepare an attribute struct for cond formatting.
        a = struct();
        a.value = THIS.data(i,j);
        a.rowvalues = THIS.data(i,:);
        a.colvalues = THIS.data(:,j);
        a.allvalues = THIS.data;
        a.rowname = THIS.options.rownames{i};
        a.colname = THIS.options.colnames{j};
        a.row = i;
        a.col = j;
    end
end