function myplot(THIS)
% MYPLOT  [Not a public function] Plot figure's children.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

% No need to test for empty `children` because `plot` is only called on
% figures that have at least one child.

% Compute subdivision.
sub = mysubplot(THIS);

% Generate child graphs or empty spaces.
for i = 1 : length(THIS.children)
    % Both `subplot` and `plot` are object specific to allow
    % for empty space `report.empty` without any axex created.
    try
        ax = subplot(THIS.children{i},sub{1},sub{2},i);
        plot(THIS.children{i},ax);
    catch Error
        utils.warning('report', ...
            'Error plotting graph in figure ''%s''.\n\tMatlab says ''%s''', ...
            THIS.title,Error.message);
    end
end

end