function [INCLGRAPH,TEMPFILES,RAISE] = mycompilepdf(THIS,OPT)
% MYCOMPILEPDF  [Not a public function] Publish figure to PDF.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

% Generate unique name for EPS of use user-supplied name.
TEMPFILES = {};
if isempty(THIS.options.saveas)
    % Generate temp file name in this folder.
    [ans,epsname] = fileparts(tempname(cd())); %#ok<NOANS,ASGLU>
    addtohelperfiles = true;
else
    % User requested a file name.
    [ans,epsname] = fileparts(THIS.options.saveas); %#ok<NOANS,ASGLU>
    addtohelperfiles = false;
end

% Set paper size to US letter because the graph proportions
% look nicer.
set(THIS.handle,'paperType','usLetter');
% Set orientation, rotation, and raise box.
if (isequal(OPT.orientation,'landscape') && ~THIS.options.sideways) ...
        || (isequal(OPT.orientation,'portrait') && THIS.options.sideways)
    orient(THIS.handle,'landscape');
    angle = -90;
    RAISE = 10;
else
    orient(THIS.handle,'tall');
    angle = 0;
    RAISE = 0;
end

% Print to coloured EPS.
print(THIS.handle,'-depsc',epsname);

% Convert EPS to PDF.
% Use try-catch to make sure the helper files are deleted.
if isequal(OPT.epstopdf,Inf)
    latex.epstopdf([epsname,'.eps']);
else
    latex.epstopdf([epsname,'.eps'],OPT.epstopdf);
end
if addtohelperfiles
    TEMPFILES{end+1} = [epsname,'.eps'];
    TEMPFILES{end+1} = [epsname,'.pdf'];
end
if strcmpi(THIS.options.figurescale,'auto')
    switch class(THIS.parent)
        case 'report.report'
            THIS.options.figurescale = 0.85;
        case 'report.align'
            THIS.options.figurescale = 0.3;
        otherwise
            THIS.options.figurescale = 1;
    end
end

INCLGRAPH = [ ...
    '\raisebox{',sprintf('%gpt',RAISE),'}{', ...
    '\includegraphics[', ...
    sprintf('scale=%g,angle=%g]{%s}', ...
    THIS.options.figurescale,angle,epsname),'}'];

end