function LEG = plot(THIS,AX)
% PLOT  [Not a public function] Plot report/band data.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

if any(strcmpi(THIS.options.plottype,{'patch','line'}))
    % Create the line plot first using the parent's method.
    [LEG,h,time,cdata,grid] = plot@report.series(THIS,AX);
    dopatch();
else
    LEG = {};
    doerrorbars();
end

% Nested functions.

%**************************************************************************

    function dopatch()    
        grid = grid(:);
        ldata = THIS.low{1}(time);
        hdata = THIS.high{1}(time);
        ldata = ldata(:,:);
        hdata = hdata(:,:);
        nx = max([size(cdata,2),size(ldata,2),size(hdata,2)]);
        nextplot = get(AX,'nextPlot');
        set(AX,'nextPlot','add');
        pt = nan(1,nx);
        
        for i = 1 : nx
            whi = THIS.options.white(min([i,end]));
            % Retrieve current set of data.
            cdatai = cdata(:,min([i,end]));
            ldatai = ldata(:,min([i,end]));
            if THIS.options.relative && all(ldatai(:) >=0 )
                ldatai = -ldatai;
            end
            hdatai = hdata(:,min([i,end]));
            % Create x- and y-data for the patch function.
            xdata = [grid;flipud(grid)];
            ydata = [ldatai;flipud(hdatai)];
            if THIS.options.relative
                ydata = ydata + [cdatai;flipud(cdatai)];
            end
            % Remove data points where either x-data or y-data is NaN.
            nanindex = isnan(xdata) | isnan(ydata);
            if all(nanindex)
                continue
            end
            xdata = xdata(~nanindex);
            ydata = ydata(~nanindex);
            % Draw patch.
            pt(i) = patch(xdata,ydata,'white');
            linecol = get(h(min([i,end])),'color');
            facecol = whi*[1,1,1] + (1-whi)*linecol;
            set(pt(i),'faceColor',facecol, ...
                'edgeColor','white', ...
                'lineStyle','-', ...
                'tag','background');
        end
        grfun.excludefromlegend(pt);
        set(AX,'nextPlot',nextplot);
    end
% dopatch().

%**************************************************************************
    function doerrorbars()
        [ans,ans,ans,data] = errorbar(AX,THIS.options.range, ...
            THIS.data{1},THIS.low{1},THIS.high{1}, ...
            'relative=',THIS.options.relative); %#ok<NOANS,ASGLU>
        LEG = mylegend(THIS,size(data,2));
    end
% doerrorbars().

end