function epstopdf(LIST,CMDARGS,varargin)
% epstopdf  [Not a public function] Run EPSTOPDF to convert EPS grapics to PDF.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

try
    CMDARGS; %#ok<VUNUS>
catch %#ok<CTCH>
   if ispc()
      % Add a border to the image. The --enlarge option doesn't exist on
      % Unix/Linux, though.
      CMDARGS = '--enlarge=10';
      % cmdArguments = '';
   else
      CMDARGS = '';
   end
end

% Parse inputarguments.
P = inputParser();
P.addRequired('LIST',@(x) ischar(x) || iscellstr(x));
P.addRequired('CMDARGS',@(x) ischar(x) || isempty(x));
P.parse(LIST,CMDARGS);

% Parse options.
options = passvalopt('latex.epstopdf',varargin{:});

%**************************************************************************

if ischar(LIST)
   LIST = regexp(LIST,'[^,;]+','match');
   LIST = strtrim(LIST);
end

thisdir = cd();
epstopdf = irisget('epstopdfpath');
if isempty(epstopdf)
   error('iris:latex',...
      'EPSTOPDF path unknown. Cannot convert EPS to PDF files.');
end

for i = 1 : length(LIST)
   [fpath,ftitle,fext] = fileparts(LIST{i});
   fpath = strtrim(fpath);
   if ~isempty(fpath)
      cd(fpath);
   end
   tmp = dir([ftitle,fext]);
   tmp([tmp.isdir]) = [];
   for j = 1 : length(tmp)
      if options.display
         fprintf('Converting \% to PDF.\n',fullfile(fpath,tmp(j).name));
      end
      command = ['"',epstopdf,'" ',tmp(j).name,' ',CMDARGS];
      system(command);
   end
   cd(thisdir);
end

end
