function default = sstate()
% sstate  [Not a public function] Default options for steady-state functions.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

default = struct();

default.sstate = { ...
   'assign',struct(),@(x) isempty(x) || isstruct(x), ...
   'saveas','',@ischar, ...
};

default.compile = { ...
   'excludezero',false,@islogicalscalar, ...
   'deletesymbolicmfiles,deletesymbolicmfile',true,@islogicalscalar, ...
   'end',Inf,@(x) isnumericscalar(x) || ischar(x), ...
   'simplify',Inf,@isnumericscalar, ...
   'start',1,@(x) isnumericscalar(x) || ischar(x), ...
   'symbolic',true,@islogicalscalar, ...
   ... Optim Tbx settings
   'tolx',1e-12,@isnumericscalar, ...
   'tolfun',1e-12,@isnumericscalar, ...
   'maxiter',500,@isnumericscalar, ...
   'maxfunevals',10000,@isnumericscalar, ...
   'display','notify',@(x) ischar(x) ...
      && any(strcmpi(x,{'notify','iter','off','final','none'})), ...
};

end