function default = rhsmodel()
% rhsmodel  [Not a public function] Default options for rhsmodel class.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

default = struct();

default.rhsmodel = { ...
    'assign',[],@(x) isempty(x) || isstruct(x), ...
    'saveas','',@ischar, ...
    'std',1,@(x) isnumericscalar(x) && x >= 0, ...
    };

default.estimate = { ...
    'display','iter',@(x) isanychar(x,{'off','none','final','iter'}), ...
    'filter',{},@(x) isempty(x) || (iscell(x) && iscellstr(x(1:2:end))), ...
    'initval','struct',@(x) any(strcmpi(x,{'struct','model'})), ...
    'maxiter',1000,@isnumericscalar, ...
    'maxfunevals',5000,@isnumericscalar, ...
    'optimset',[],@(x) isempty(x) || isstruct(x) || (iscell(x) && iscellstr(x(1:2:end))), ...
    'tolx',1e-10,@isnumericscalar, ...
    'tolfun',1e-10,@isnumericscalar, ...
    };

default.kalman = { ...
    'ahead',1,@(x) isnumericscalar(x) && x > 0 && round(x) == x, ...
    'optimset',{},@(x) iscell(x) && iscellstr(x(1:2:end)), ...
    'relative',true,@islogicalscalar, ...
    };

default.simulate = { ...
    'deviation',false,@islogicalscalar, ...
    'enbloc',false,@islogicalscalar, ...
    'esttime',false,@islogicalscalar, ...
    'ndraw',1,@(x) isnumericscalar(x) && x >= 1 && x == round(x), ...
    'optimset',{},@(x) iscell(x) && iscellstr(x(1:2:end)), ...
    'plan',[],@(x) isempty(x) || isa(x,'plan'), ...
    'progress',false,@islogicalscalar, ...
    'residuals,residual','data',@(x) isequal(x,'data') || isa(x,'function_handle'), ...
    'solvefor','endogenous',@(x) any(strcmpi(x,{'endogenous','residuals'})), ...
    'solver','lsqnonlin',@(x) isanychar(x,{'lsqnonlin','fsolve'}), ...
    };

end