function default = report()
% REPORT  [Not a public function] Default options for report functions.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

default = struct();

default.publish = { ...
    'abstract','',@ischar, ...
    'author','',@ischar, ...
    'cleanup',true,@islogicalscalar, ...
    'date','\today',@ischar, ...
    'deletelatex',[],@(x) isempty(x) || islogicalscalar(x), ...
    'deletetempfiles,cleanup',[],@(x) isempty(x) || islogicalscalar(x), ...
    'epstopdf',Inf,@(x) isequal(x,Inf) || ischar(x), ...
    'fontenc','T1',@ischar, ...
    'maketitle',false,@islogical, ...
    'papersize','letterpaper',@(x) any(strcmpi(x,{'a4','a4paper','letter','letterpaper'})), ...
    'package',{},@(x) ischar(x) || iscellstr(x) || isempty(x), ...
    'preamble','',@ischar, ...
    'progress',false,@islogicalscalar, ...
    'title',Inf,@(x) ischar(x) || isequal(x,Inf), ...
    'timestamp',@() datestr(now()),@(x) ischar(x) || isa(x,'function_handle'), ...
    'textscale',0.8,@isnumericscalar, ...
    };

end
