function def = model()
% MODEL  [Not a public function] Default options for model class functions.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

deviation_dtrends = { ...
    'deviation,deviations',false,@islogicalscalar, ...
    'dtrends,dtrend','auto',@(x) islogicalscalar(x) || isequal(x,'auto'), ...
    };

precision = { ...
    'precision','double',@(x) isanychari(x,{'double','single'}), ...
    };

applyfilter = {
    'applyto',Inf,@(x) isequal(x,':') || isequal(x,Inf) || iscellstr(x), ...
    'filter','',@ischar, ...
    };

swap = { ...
    'endogenise,endogenize',{},@(x) isempty(x) || iscellstr(x) || ischar(x), ...
    'exogenise,exogenize',{},@(x) isempty(x) || iscellstr(x) || ischar(x), ...
    };

output = { ...
    'output','namedmat',@(x) ischar(x) && any(strcmpi(x,{'namedmat','numeric'})), ...
    };

sstate = { ...
    'algorithm',[],@(x) ischar(x) || isa(x,'function_handle'), ...
    'blocks,block',false,@islogicalscalar, ...
    swap{:}, ...
    'fix',{},@(x) isempty(x) || iscellstr(x) || ischar(x), ...
    'fixallbut',{},@(x) isempty(x) || iscellstr(x) || ischar(x), ...
    'fixlevel',{},@(x) isempty(x) || iscellstr(x) || ischar(x), ...
    'fixlevelallbut',{},@(x) isempty(x) || iscellstr(x) || ischar(x), ...
    'fixgrowth',{},@(x) isempty(x) || iscellstr(x) || ischar(x), ...
    'fixgrowthallbut',{},@(x) isempty(x) || iscellstr(x) || ischar(x), ...
    'growth',false,@islogicalscalar, ...
    'maxiter',1000,@(x) isnumeric(x) && length(x) == 1 && round(abs(x)) == x, ...
    'maxfunevals',1000,@(x) isnumeric(x) && length(x) == 1 && round(abs(x)) == x, ...
    'optimset',{},@(x) isempty(x) || (iscell(x) && iscellstr(x(1:2:end))), ...
    'naninit,init',1,@(x) isnumericscalar(x) && isfinite(x), ...
    'refresh',true,@islogicalscalar, ...
    'resetinit',[],@(x) isempty(x) || (isnumericscalar(x) && isfinite(x)), ...
    'solve',false,@islogicalscalar, ...
    'solver','lsqnonlin',@(x) ischar(x) || isa(x,'function_handle'), ...
    'tolx',1e-12,@(x) isnumeric(x) && length(x) == 1 && x > 0, ...
    'tolfun',1e-12,@(x) isnumeric(x) && length(x) == 1 && x > 0, ...
    'zeromultipliers',false,@islogicalscalar, ...
    };

def = struct();

def.acf = {
    'acf',{},@(x) iscell(x) && iscellstr(x(1:2:end)), ...
    applyfilter{:}, ...
    'nfreq',256,@isnumericscalar, ...
    'contributions,contribution',false,@islogicalscalar, ...
    'order',0,@isnumericscalar, ...
    output{:}, ...
    'select',Inf,@(x) (isnumeric(x) && all(isinf(x))) || iscellstr(x) || ischar(x), ...
    }; %#ok<*CCAT>

def.bn = { ...
    deviation_dtrends{:}, ...
    }; %#ok<CCAT1>

def.chksstate = { ...
    'error',true,@islogicalscalar, ...
    'refresh',true,@islogicalscalar, ...
    'sort',false,@islogicalscalar, ...
    'sstateeqtn',false,@islogicalscalar, ...
    'tolerance',getrealsmall(),@isnumericscalar, ...
    'warning',true,@islogicalscalar, ...
    };

def.diffloglik = {...
    'progress',false,@islogicalscalar, ...
    'refresh',true,@islogicalscalar, ...
    'solve',true,@islogicalscalar, ...
    'sstate',false,@(x) islogical(x) || (iscell(x) && iscellstr(x(1:2:end))), ...
    };

def.estimate = { ...
    'domain','time',@(x) any(strncmpi(x,{'t','f'},1)), ...
    'filter',{},@(x) isempty(x) ...
    || (iscell(x) && iscellstr(x(1:2:end))), ...
    'nosolution','error',@(x) any(strcmpi(x,{'error','penalty'})), ...
    'refresh',true,@islogicalscalar, ...
    'solve',true,@islogicalscalar, ...
    'sstate',false,@(x) islogical(x) || (iscell(x) && iscellstr(x(1:2:end))) ...
    || isa(x,'function_handle'), ...
    'zero',false,@islogicalscalar, ...
    };

def.fevd = {
    'select',Inf,@(x) isequal(x,Inf) || ischar(x) || iscellstr(x), ...
    output{:}, ...
    };

def.fmse = {
    'select',Inf,@(x) isequal(x,Inf) || ischar(x) || iscellstr(x), ...
    output{:}, ...
    };

def.ffrf = {
    'exclude',[],@(x) isempty(x) || ischar(x) || iscellstr(x), ...
    'maxiter',500,@isnumericscalar, ...
    output{:}, ...
    'select',Inf,@(x) isequal(x,Inf) || ischar(x) || iscellstr(x), ...
    'tolerance',1e-7,@isnumericscalar, ...
    };

def.filter = { ...
    'ahead',1,@(x) isnumericscalar(x) && x > 0 && x == round(x), ...    
    'data,output','smooth',@(x) ischar(x), ...
    'rollback',[],@isnumeric, ...
    };

def.fisher = { ...
    'chksgf',false,@islogicalscalar, ...
    'deviation',true,@islogicalscalar, ...
    'epspower',1/3,@isnumericscalar, ...
    'exclude',{},@(x) ischar(x) || iscellstr(x), ...
    'percent',false,@islogicalscalar, ...
    'progress',false,@islogicalscalar, ...
    'refresh',true,@islogicalscalar, ...
    'solve',true,@islogicalscalar, ...
    'sstate',false,@(x) islogical(x) || (iscell(x) && iscellstr(x(1:2:end))), ...
    'sstateeffect',[],@(x) isempty(x) || islogical(x), ...
    'tolerance',eps()^(2/3),@isnumericscalar, ...
    };

def.forecast = {...
    'anticipate',true,@islogicalscalar, ...
    deviation_dtrends{:}, ...
    'initcond','data',@(x) any(strcmpi(x,{'data','fixed'})) || isnumeric(x), ...
    'meanonly',false,@islogicalscalar, ...
    'std',[],@(x) isstruct(x) || isempty(x), ...
    'tolmse',getrealsmall('mse'),@(x) isnumeric(x) && length(x) == 1, ...
    };

def.jforecast = {...
    'anticipate',true,@islogicalscalar, ...
    'currentonly',true,@islogicalscalar, ...
    deviation_dtrends{:}, ...
    'initcond','data',@(x) any(strcmpi(x,{'data','fixed'})) || isnumeric(x), ...
    'meanonly',false,@islogicalscalar, ...
    'precision','double',@(x) ischar(x) && any(strcmpi(x,{'double','single'})), ...
    'progress',false,@islogicalscalar, ...
    'plan',[],@(x) isa(x,'plan') || isempty(x), ...
    'std',[],@(x) isempty(x) || isstruct(x), ...
    'vary',[],@(x) isstruct(x) || isempty(x), ...
    };

def.icrf = {...
    'delog',true,@islogicalscalar,...
    'log',[],@(x) isempty(x) || islogicalscalar(x), ...
    'size',[],@(x) isempty(x) || isnumericscalar(x), ...
    };

def.ifrf = {...
    'select',Inf,@(x) isequal(x,Inf) || ischar(x) || iscellstr(x), ...
    };

def.loglik = { ...
    'domain','time',@(x) any(strncmpi(x,{'t','f'},1)), ...
    'persist',false,@islogicalscalar, ...
    };

def.fdlik = { ...
    'band',[2,Inf],@(x) isnumeric(x) && length(x) == 2, ...
    deviation_dtrends{:}, ...
    'exclude',[],@(x) isempty(x) || ischar(x) || iscellstr(x) || islogical(x), ...
    'outoflik',{},@(x) ischar(x) || iscellstr(x), ...
    'relative',true,@islogicalscalar, ...
    'zero',true,@islogicalscalar, ...
    };

def.lognormal = { ...
    'fresh',false,@islogicalscalar, ...
    'mean',true,@islogicalscalar, ...
    'median',true,@islogicalscalar, ...
    'mode',true,@islogicalscalar, ...
    'pctile',[5,95],@(x) isnumeric(x) && all(round(x(:)) > 0 & round(x(:)) < 100), ...
    'prefix','lognormal',@(x) ischar(x) && ~isempty(x), ...
    'std',true,@islogicalscalar, ...
    };

def.kalman = { ...
    'chkexact',false,@islogicalscalar, ...
    'chkfmse',false,@islogicalscalar, ...
    deviation_dtrends{:}, ...
    'exclude',[],@(x) isempty(x) || ischar(x) || iscellstr(x) || islogical(x), ...
    'initcond','stochastic',@(x) ...
    isstruct(x) ...
    || (ischar(x) && any(strcmpi(x,{'stochastic','fixed','optimal'}))), ...
    'lastsmooth',Inf,@(x) isempty(x) || isnumericscalar(x), ...
    'nonlinearise,nonlinearize',0,@(x) isnumericscalar(x) && x == round(x) && x >= 0, ...
    'outoflik',{},@(x) ischar(x) || iscellstr(x), ...
    'objective','loglik',@(x) any(strcmpi(x,{'loglik','mloglik','-loglik','prederr'})), ...
    'objrange',Inf,@isnumeric, ...
    'objectivesample',[],@isnumeric, ...
    'pedindonly',false,@islogicalscalar, ...
    precision{:}, ...
    'plan',[],@(x) isa(x,'plan') || isempty(x), ...
    'progress',false,@islogicalscalar, ...
    'relative',true,@islogicalscalar, ...
    'std',[],@(x) isempty(x) || isstruct(x), ...
    'vary',[],@(x) isempty(x) || isstruct(x), ...
    'simulate',{},@(x) iscell(x) && iscellstr(x(1:2:end)), ...
    'symmetric',true,@islogicalscalar, ...
    'tolerance',eps()^(2/3),@isnumeric, ...
    'tolmse',0,@(x) (ischar(x) && strcmpi(x,'auto')) || isnumericscalar(x), ...
    'weighting',[],@isnumeric, ...
    'meanonly',false,@islogicalscalar, ...
    'returnstd',true,@islogicalscalar, ...
    'returnmse',true,@islogicalscalar, ...
    };

def.model = {
    'addlead',false,@islogicalscalar, ...
    'multiple,allowmultiple',false,@islogicalscalar, ...
    'assign',[],@(x) isempty(x) || isstruct(x), ...
    'comment','',@ischar, ...
    'epsilon',eps^(1/3),@isnumericscalar, ...
    'removeleads,removelead',false,@islogicalscalar, ...
    'linear',[],@(x) isempty(x) || islogical(x), ...
    'multipliername','Mu_Eq%g',@(x) ischar(x) && ~isempty(strfind(x,'%g')), ...
    'precision','double',@(x) any(strcmp(x,{'double','single'})), ...
    'quadratic',false,@islogicalscalar, ...
    'saveas','',@ischar, ...
    'std',NaN,@isnumericscalar, ...
    'torigin',2000,@isnumericscalar, ...
    };

def.neighbourhood = { ...
    'plot',true,@islogicalscalar, ...
    'progress',false,@islogicalscalar, ...
    'neighbourhood',[],@(x) isempty(x) || isstruct(x), ...
    };

def.tcorule = { ...
    'beta',1,@isnumericscalar, ...
    'display',5000,@isnumericscalar, ...
    'ginverse',false,@islogicalscalar, ...
    'initexp',@eye,@(x) isnumeric(x) || isfunc(x), ...
    'maxiter',50000,@isnumericscalar, ...
    'reset',false,@islogicalscalar, ...
    'tolexp',1e-10,@isnumericscalar, ...
    'tolrule',1e-10,@isnumericscalar, ...
    'tolvalue',1e-6,@isnumericscalar, ...
    'warning',true,@islogicalscalar, ...
    };

def.regress = { ...
    'acf',{},@(x) iscell(x) && iscellstr(x(1:2:end)), ...
    output{:}, ...
    };
    
def.resample = { ...
    deviation_dtrends{:}, ...
    'method','montecarlo',@(x) isa(x,'function_handle') ...
    || (ischar(x) && any(strcmpi(x,{'montecarlo','bootstrap'}))), ...
    'progress',false,@islogicalscalar, ...
    'randomise,randomize',true,@(x) islogicalscalar(x) || (isnumericscalar(x) && x >= 0), ...
    'svdonly',false,@islogicalscalar, ...
    'statevector','alpha',@(x) ischar(x) && any(strcmpi(x,{'alpha','x'})), ...
    'wild',false,@islogicalscalar, ...
    };

def.shockplot = { ...
    'deviation',true,@islogicalscalar, ...
    'dtrends,dtrend','auto',@(x) islogicalscalar(x) || isequal(x,'auto'), ...
    'shocksize','std',@(x) (ischar(x) && strcmpi(x,'std')) || isnumeric(x), ...
    };

def.simulate = { ...
    'anticipate',true,@islogicalscalar, ...
    'contributions,contribution',false,@islogicalscalar, ...
    'dbextend',false,@(x) islogicalscalar(x) || isstruct(x), ...
    deviation_dtrends{:}, ...
    'fast',true,@islogicalscalar, ...
    'ignoreresiduals,ignoreresidual',[],@(x) isempty(x) || islogicalscalar(x), ...
    'ignoreshocks,ignoreshock',false,@islogicalscalar, ...
    'plan',[],@(x) isa(x,'plan') || isempty(x), ...
    'progress',false,@islogicalscalar, ...
    'missing',NaN,@isnumeric, ...
    ... Options for non-linear simulations
    'nonlinearise,nonlinearize',0,@(x) isempty(x) || isnumeric(x), ...
    'addsstate',true,@islogicalscalar, ...
    'display',100,@(x) islogicalscalar(x) || (isnumericscalar(x) && x >= 0 && x == round(x)), ...
    'error',false,@islogicalscalar, ...
    'lambda',1,@(x) isnumericscalar(x) && x > 0 && x <= 1, ...
    'lambdafactor',[],@(x) isempty(x) || (isnumericscalar(x) && x > 0 && x <= 1), ...
    'reducelambda',0.5,@(x) isnumericscalar(x) && x > 0 && x <= 1, ...
    'maxiter',100,@isnumericscalar, ...
    'tolerance',1e-5,@isnumericscalar, ...
    };

def.solve = { ...
    'expand',0,@(x) isnumeric(x) && length(x) == 1, ...
    'logbook',false,@islogicalscalar, ...
    'error',false,@islogicalscalar, ...
    'forward',0,@(x) isnumeric(x) && length(x) == 1, ...
    'progress',false,@islogicalscalar, ...
    'refresh',true,@islogicalscalar, ...
    'select',true,@islogicalscalar, ...
    'symbolic',true,@islogicalscalar, ...
    'tolerance',getrealsmall(),@(x) isnumeric(x) && length(x) == 1, ...
    'warning',true,@islogicalscalar, ...
    };

def.sourcedb = { ...
    'ndraw',1,@(x) isnumericscalar(x) && x >= 0 && x == round(x), ...
    'ncol',1,@(x) isnumericscalar(x) && x >= 0 && x == round(x), ...
    deviation_dtrends{:}, ...
    'randomshocks,randomshock',false,@islogicalscalar, ...
    'residuals,residual',[],@(x) isempty(x) || isa(x,'function_handle'), ...
    };

def.srf = {...
    'log',[],@(x) isempty(x) || islogicalscalar(x), ...
    'delog',true,@islogicalscalar, ...
    'select',Inf,@(x) (isnumeric(x) && length(x) == 1 && isinf(x)) || iscellstr(x) || ischar(x), ...
    'size','std',@(x) (ischar(x) && strcmpi(x,'std')) || isnumericscalar(x), ...
    };

def.sspace = { ...
    'triangular',true,@islogicalscalar, ...
    'removeinactive',false,@islogicalscalar, ...
    };

def.sstate = { ...
    sstate{:}, ...
    'display','iter',@(x) isempty(x) || islogical(x) || isanychari(x,{'iter','final','off','notify','none'}), ...
    'persist',false,@islogicalscalar, ...
    'warning',true,@islogicalscalar, ...
    };

def.sstatepersist = { ...
    sstate{:}, ...
    'display','off',@(x) isempty(x) || islogical(x) || isanychari(x,{'iter','final','off','notify','none'}), ...
    'persist',true,@islogicalscalar, ...
    'warning',false,@islogicalscalar, ...
    };

def.sstatefile = { ...
    swap{:}, ...
    'growthnames,growthname','d?',@ischar, ...
    'time',true,@islogicalscalar, ...
    };

def.system = { ...
    'symbolic',true,@islogicalscalar, ...
    };

def.VAR = { ...
    'order',1,@isnumericscalar, ...
    'constant',true,@islogicalscalar, ...
    };

def.vma = {
    'select',Inf,@(x) isequal(x,Inf) || ischar(x) || iscellstr(x), ...
    output{:}, ...
    };

def.xsf = {
    applyfilter{:}, ...
    output{:}, ...
    'progress',false,@islogicalscalar, ...
    'select',Inf,@(x) isequal(x,Inf) || ischar(x) || iscellstr(x), ...
    };

end