function default = latex()
% LATEX  [Not a public function] Default options for latex package functions.
%
% Backend IRIS function.
% No help provided.

% The IRIS Toolbox.
% Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

default = struct();

default.epstopdf = {...
    'display',false,@islogical,...
    };

default.compilepdf = { ...
    'display',true,@islogicalscalar, ...
    'maxrerun',5,@isnumericscalar, ...
    };

default.publish = { ...
    'author','',@ischar, ...
    'cleanup',true,@islogicalscalar, ...
    'closeall',true,@islogicalscalar, ...
    'date','\today',@ischar, ...
    'deletetempfiles,cleanup',[],@(x) isempty(x) || islogicalscalar(x), ...
    'display',true,@islogicalscalar, ...
    'evalcode',true,@islogicalscalar, ...
    'figurescale',1,@(x) isnumericscalar(x) && x > 0, ...
    'figurewidth','4in',@ischar, ...
    'irisversion',true,@islogicalscalar, ...
    'linespread','auto',@(x) (ischar(x) && strcmpi(x,'auto')) ...
    || isnumericscalar(x) && x > 0, ...
    'matlabversion',true,@islogicalscalar, ...
    'numbered',true,@islogicalscalar, ...
    'papersize','letterpaper', ...
    @(x) isequal(x,'a4paper') || isequal(x,'letterpaper'), ...
    'preamble','',@ischar, ...
    'package',{},@(x) iscellstr(x) || ischar(x) || isempty(x), ...
    'template','paper',@(x) ischar(x) && any(strcmpi(x,{'paper','present'})), ...
    'textscale',0.70,@isnumericscalar, ...
    'toc',true,@islogicalscalar, ...
    'usenewfigure',false,@islogicalscalar, ...
    };

end