function DEF = grfun()
% GRFUN  [Not a public function] Default options for the +grfun package.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

DEF = struct();

caption = { ...
    'caption','',@ischar, ...
    'vposition','top', ...
    @(x) (isnumericscalar(x) && x >= 0 && x <= 1) ...
    || (ischar(x) && any(strcmpi(x,{'top','bottom','centre','center','middle'}))), ...
    'hposition','right', ...
    @(x) ischar(x) && any(strcmpi(x,{'right','left','centre','center','middle'})), ...
    };

DEF.vline = {
    caption{:}, ...
    'excludefromlegend',true,@islogicalscalar, ...
    'timeposition','middle',@(x) isanychari(x,{'middle','before','after'}), ...
    };

DEF.highlight = { ...
    caption{:}, ...
    'grade',[],@(x) isnumeric(x) && length(x) <= 1, ...
    'excludefromlegend',true,@islogicalscalar, ...
    'colour',0.8*[1,1,1],@(x) (isnumeric(x) && length(x) == 3) || ischar(x), ...
    'color',[],@(x) isempty(x) || (isnumeric(x) && length(x) == 3) || ischar(x), ...
    'around',0,@isnumericscalar, ...
    };

DEF.plotcircle = { ...
    'fill',false,@islogicalscalar, ...
    };

DEF.ploteig = { ...
    'ucircle',true,@islogicalscalar, ...
    };

DEF.plotmat = { ...
    'colnames,colname',{},@(x) isempty(x) || iscellstr(x) || ischar(x), ...
    'rownames,rowname',{},@(x) isempty(x) || iscellstr(x) || ischar(x), ...
    'maxcircle',false,@islogicalscalar, ...
    'scale','auto',@(x) (ischar(x) && strcmpi(x,'auto')) ...
    || (isnumericscalar(x) && x > 0), ...
    ... Bkw compatibility options:
    'frame',[],@(x) isempty(x) || islogicalscalar(x), ...
    };

DEF.plotneigh = { ...
    'plotobj',true,@(x) islogicalscalar(x), ...
    'plotlik',true,@(x) islogicalscalar(x), ...
    'plotest',true,@(x) islogicalscalar(x), ...
    'plotbounds',true,@(x) islogicalscalar(x), ...
    'subplot','auto',@(x) isnumeric(x) || (ischar(x) && strcmpi(x,'auto')), ...
    'linkaxes',false,@islogicalscalar, ...
    };

DEF.plotpp = { ...
    'describeprior','auto',@(x) isequal(x,'auto') || islogicalscalar(x), ...
    'plotprior',true,@islogicalscalar, ...
    'plotposter',true,@islogicalscalar, ...
    'plotbounds',false,@islogicalscalar, ...
    'sigma',3,@(x) isnumericscalar(x) && x > 0, ...
    'subplot','auto',@(x) isequal(x,'auto') ...
    || (isnumeric(x) && length(x) == 2 && all(x == round(x)) && all(x > 0)), ...
    'tight',true,@islogicalscalar, ...
    'xlims',[],@(x) isempty(x) || isstruct(), ...
    };

DEF.ftitle = { ...
    'location','north',@(x) isanychari(x,{'north','west','east','south'}), ...
    };

DEF.title = { ...
    ... 'interpreter','latex',@(x) isanychari(x,{'latex','none'}), ...
    };

end