function default = estimateobj()
% ESTIMATEOBJ  [Not a public function] Default options for estimateobj class functions.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

default.myestimate = { ...
    'display','iter',@(x) any(strcmp(x,{'iter','final','none','off'})), ...
    'epspower',1/2,@isnumeric, ...
    'initval','struct',@(x) any(strcmpi(x,{'struct','model'})), ...
    'maxiter',500,@(x) isnumericscalar(x) && x >= 0, ...
    'maxfunevals',2000,@(x) isnumericscalar(x) && x > 0, ...
    'optimset',[],@(x) isempty(x) || isstruct(x) || (iscell(x) && iscellstr(x(1:2:end))), ...
    'penalty',0,@(x) isnumericscalar(x) && x >= 0, ...
    'solver','fmin',@(x) (ischar(x) && any(strcmpi(x,{'fmin','lsqnonlin'}))) ...
    || iscell(x) || isa(x,'function_handle'), ...
    'tolfun',1e-6,@(x) isnumeric(x) && x > 0, ...
    'tolx',1e-6,@(x) isnumeric(x) && x > 0, ...
    };

end