function default = dates()
% dates  [Not a public function] Default options for date functions.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

default = struct();

config = irisget();

default.convert = {
   'standinmonth','config',config.validate.standinmonth, ...
};

default.dat2str = {
   'dateformat','config',config.validate.dateformat, ...
   'freqletters,freqletter','config',config.validate.freqletters, ...
   'months,month','config',config.validate.months, ...
   'standinmonth','config',config.validate.standinmonth, ...
};

default.str2dat = {
   'dateformat','config',config.validate.dateformat, ...
   'freq',[],@(x) isempty(x) ...
      || (isnumericscalar(x) && any(x == [0,1,2,4,6,12])), ...
   'freqletters,freqletter','config',config.validate.freqletters, ...
   'months,month','config',config.validate.months, ...
};

end