function default = data()
% data  [Not a public function] Default options for database functions.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

default = struct();

config = irisget();

dateformat = { ...
    'dateformat','config',config.validate.dateformat, ...
    'freqletters,freqletter','config',config.validate.freqletters, ...
    'months,month','config',config.validate.months, ...
    'standinmonth','config',config.validate.standinmonth, ...
    };

default.dbbatch = {
    'append',[],@(x) isempty(x) || islogical(x), ...
    'classfilter',Inf,@(x) (isnumeric(x) && isinf(x)) || ischar(x), ...
    'freqfilter',Inf,@isnumeric, ...
    'merge',[],@(x) isempty(x) || islogical(x), ...
    'namefilter',Inf,@(x) (isnumeric(x) && isinf(x)) || ischar(x), ...
    'namelist',Inf,@(x) (isnumeric(x) && isinf(x)) || ischar(x) || iscellstr(x), ...
    'fresh',false,@(x) islogical(x) || isstruct(x), ...
    'stringlist',{},@(x) iscellstr(x) || ischar(x), ...
    };

default.dbload = { ...
    dateformat{:}, ...
    'case','',@(x) isempty(x) || any(strcmpi(x,{'lower','upper'})), ...
    'changecase','',@(x) isempty(x) || any(strcmpi(x,{'lower','upper'})), ...
    'commentrow',{'comment','comments'},@(x) ischar(x) || iscellstr(x), ...
    'delimiter',',',@(x) ischar(x) && length(sprintf(x)) == 1, ...
    'leadingrow',{'','variables'},@(x) ischar(x) || iscellstr(x) || isnumericscalar(x), ...
    'namefunc',[],@(x) isempty(x) || isfunc(x), ...
    'freq',[],@(x) isempty(x) || (ischar(x) && strcmpi(x,'daily')) || (length(x) == 1 && isnan(x)) || (isnumeric(x) && length(x) == 1 && any(x == [0,1,2,4,6,12,365])), ...
    'nan','NaN',@(x) ischar(x), ...
    'skiprows,skiprow','',@(x) isempty(x) || ischar(x) || iscellstr(x) || isnumeric(x), ...
    'userdata',Inf,@(x) isequal(x,Inf) || (ischar(x) && isvarname(x)), ...
    'userdatafield','.',@(x) ischar(x) && length(x) == 1, ...
    }; %#ok<CCAT>

default.dbfun = { ...
    'cascade',true,@islogicalscalar, ...
    'classfilter',Inf,@(x) (isnumeric(x) && isinf(x)) || ischar(x) || iscellstr(x), ...
    'fresh',false,@islogicalscalar, ...
    'merge',[],@(x) isempty(x) || islogicalscalar(x), ...
    };

default.dbnames = { ...
    'classfilter',Inf,@(x) isequal(x,Inf) || ischar(x), ...
    'namefilter',Inf,@(x) isequal(x,Inf) || ischar(x), ...
    };

default.dbplot = { ...
    'addclick',true,@islogicalscalar, ...
    'class',true,@islogicalscalar, ...
    'format','%.8e',@ischar, ...
    'highlight',[],@(x) isnumeric(x) ...
    || (iscell(x) && all(cellfun(@isnumeric,x))), ...
    'marks,mark',{},@iscellstr, ...
    'round',Inf,@(x) isnumericscalar(x) && x > 0 && x == round(x), ...
    'plotfunc',@plot,@isfunc, ...
    'saveas','',@ischar, ...
    'style',[],@(x) isempty(x) || isstruct(x) || (iscellstr(x) && length(x) == 1), ...
    'subplot','auto',@(x) strcmpi(x,'auto') || (isnumeric(x) && length(x) == 2), ...
    'title',{},@(x) isempty(x) || iscellstr(x) || ischar(x), ...
    'tight',false,@islogical, ...
    'transform',[],@(x) isempty(x) || isa(x,'function_handle'), ...
    'vline',[],@isnumeric, ...
    'xlabel','',@(x) ischar(x) || iscellstr(x), ...
    'ylabel','',@(x) ischar(x) || iscellstr(x), ...
    ... 'zlabel','',@(x) ischar(x) || iscellstr(x), ...
    'zeroline',false,@islogicalscalar, ...
    };

default.dbrange = { ...
    'startdate','maxrange',@(x) ischar(x) && any(strcmpi(x,{'maxrange','minrange','balanced','unbalanced'})), ...
    'enddate','maxrange',@(x) ischar(x) && any(strcmpi(x,{'maxrange','minrange','balanced','unbalanced'})), ...
    };

default.dbsave = { ...
    dateformat{:}, ...
    'class',true,@islogicalscalar, ...
    'comment',true,@islogicalscalar, ...
    'decimal',[],@(x) isempty(x) || (length(x) == 1 && isnumeric(x)), ...
    'format','%.8e',@(x) ischar(x) && ~isempty(x) && x(1) == '%' ...
    && isempty(strfind(x,'$')) && isempty(strfind(x,'-')), ...
    'nan','NaN',@ischar, ...
    'userdata','userdata',@(x) ischar(x) && isvarname(x), ...
    }; %#ok<CCAT>

end