function default = bkwmodel()
% bkwmodel  Default options for bkwmodel class.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

default = struct();

default.bkwmodel = { ...
   'assign',[],@(x) isempty(x) || isstruct(x), ...
   'saveas','',@ischar, ...
};

default.estimate = { ...
   'cov','auto', @(x) isequal(x,'auto') || isnumeric(x), ...
   'cross',true,@(x) islogicalscalar(x) ...
      || (isnumericscalar(x) && x >= 0 && x <= 1), ...
   'logdeta',true,@islogicalscalar, ...
   'display','iter',@(x) isanychar(x,{'off','none','final','iter'}), ...
   'exclude',{},@(x) isempty(x) || iscellstr(x) || ischar(x), ...
   'filter',{},@(x) isempty(x) || (iscell(x) && iscellstr(x(1:2:end))), ...
   'niter',1,@isnumericscalar, ...
   'maxiter',1000,@isnumericscalar, ...
   'maxfunevals',5000,@isnumericscalar, ...
   'nanresid',NaN,@isnumericscalar, ...
   'optimset',[],@(x) isempty(x) || isstruct(x) || (iscell(x) && iscellstr(x(1:2:end))), ...
   'relative',true,@islogicalscalar, ...
   'report',Inf,@isnumericscalar, ...
   'tolx',1e-10,@isnumericscalar, ...
   'tolfun',1e-10,@isnumericscalar, ...
};

default.filter = { ...
   'display','off',@(x) isanychar(x,{'none','off','final','iter'}), ...
   'maxiter',10, @(x) isnumericscalar(x) && x >= 0 && x == round(x), ...
   'maxfunevals',1000, @(x) isnumericscalar(x) && x >= 0 && x == round(x), ...
   'tolx',1e-10, @(x) isnumericscalar(x) && x > 0, ...
   'tolfun',1e-10, @(x) isnumericscalar(x) && x > 0, ...
   'optimset',[],@(x) isempty(x) || isstruct(x), ...
};

default.simulate = { ...
   'deviation',false,@islogicalscalar, ...
   'display','off',@(x) isanychar(x,{'none','off','final','iter'}), ...
   'enbloc',false,@islogicalscalar, ...
   'esttime',false,@islogicalscalar, ...
   'maxiter',1000,@isnumericscalar, ...
   'maxfunevals',1000,@isnumericscalar, ...
   'ndraw',1,@(x) isnumericscalar(x) && x >= 1 && x == round(x), ...
   'optimset',[],@(x) isempty(x) || isstruct(x) || (iscell(x) && iscellstr(x(1:2:end))), ...
   'plan',[],@(x) isempty(x) || isa(x,'plan'), ...
   'progress',false,@islogicalscalar, ...
   'residuals,residual','data',@(x) isequal(x,'data') || isa(x,'function_handle'), ...
   'solver','lsqnonlin',@(x) isanychar(x,{'lsqnonlin','fsolve'}), ...
   'tolx',1e-10,@isnumericscalar, ...
   'tolfun',1e-10,@isnumericscalar, ...
};

end