function def = VAR()
% VAR  [Not a public function] Default options for VAR class functions.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

def = struct();

outputformat = { ...
    'output','auto',@(x) any(strcmpi(x,{'auto','dbase','tseries','array'})), ...
    };

applyfilter = { ...
    'applyto',Inf,@(x) isnumeric(x) || islogical(x) || isequal(x,':') || iscellstr(x), ...
    'filter','',@ischar, ...
    };

def.acf = { ...
    applyfilter{:}, ...
    'nfreq',256,@isnumericscalar, ...
    'order',0,@isnumericscalar, ...
    'progress',false,@islogicalscalar, ...
    }; %#ok<*CCAT>

def.demean = [ ...
    outputformat, ...
    ];

def.estimate = [ ...
    outputformat, { ...
    'a',[],@isnumeric, ...
    'bvar',[],@(x) isempty(x) || isnumeric(x), ...
    'c',[],@isnumeric, ...
    'diff',false,@islogicalscalar, ...
    'g',[],@isnumeric, ...
    'order',1,@(x) isnumeric(x) && numel(1) == 1, ...
    'cointeg',[],@isnumeric, ...
    'constraints,constraint','',@(x) ischar(x) || isnumeric(x), ...
    'const',[],@(x) isempty(x) || islogicalscalar(x), ...
    'constant',true,@islogicalscalar, ...
    'covparameters,covparameter',false,@islogicalscalar, ...
    'eqtnbyeqtn',false,@islogicalscalar, ...
    'maxiter',1,@isnumericscalar, ...
    'mean',[],@(x) isempty(x) || isnumeric(x), ...
    'progress',false,@islogicalscalar, ...
    'schur',true,@islogicalscalar, ...
    'stdize',false,@islogicalscalar, ...
    'tolerance',1e-5,@isnumericscalar, ...
    'ynames,yname',{},@iscellstr, ...
    'enames,ename',{},@iscellstr, ...
    'userdata',[],true, ...
    'warning',true,@islogicalscalar, ...
    }];

def.fmse = { ...
    'output','tseries',@(x) any(strcmpi(x,{'dbase','tseries'})), ...
    };

def.forecast = [ ...
    outputformat, { ...
    'cross',true, ...
    @(x) islogicalscalar(x) || (isnumericscalar(x) && x >=0 && x <= 1), ...
    'deviation',false,@islogicalscalar, ...
    'meanonly',false,@islogicalscalar, ...
    'omega',[],@isnumeric, ...
    'returnmse',[],@(x) isempty(x) || islogicalscalar(x), ...
    'returnresiduals,returnresidual',true,@islogicalscalar, ...
    }];

def.integrate = [ ...
    outputformat, { ...
    'applyto',Inf,@(x) isnumeric(x) || islogical(x), ...
    }];

def.portest = { ...
    'level',0.05,@(x) isnumericscalar(x) && x > 0 && x < 1, ...
    };

def.resample = [ ...
    outputformat, {
    'method','montecarlo',@(x) isa(x,'function_handle') ...
    || (ischar(x) && any(strcmpi(x,{'montecarlo','bootstrap'}))), ...
    'progress',false,@islogicalscalar, ...
    'randomise,randomize',false,@islogicalscalar, ...
    'wild',false,@islogicalscalar, ...
    }];

def.simulate = [ ...
    outputformat, { ...
    'contributions,contribution',false,@islogicalscalar, ...
    'deviation,deviations',false,@islogicalscalar, ...
    'returnresiduals,returnresidual',true,@islogicalscalar, ...
    }];

def.sprintf = { ...
    'constant,constants,const',true,@islogicalscalar, ...
    'decimal',[], @(x) isempty(x) || isnumericscalar(x), ...
    'declare',false,@islogicalscalar, ...
    'enames,ename',[],@(x) isempty(x) || iscellstr(x) || isfunc(x), ...
    'format','%+.16e',@ischar, ...
    'hardparameters,hardparameter',true,@islogicalscalar, ...
    'tolerance',getrealsmall(),@isnumericscalar, ...
    'ynames,yname',[],@(x) isempty(x) || iscellstr(x), ...
    };

def.VAR = { ...
    'userdata',[],true, ...
    };

def.xsf = { ...
    applyfilter{:}, ...
    'progress',false,@islogicalscalar, ...
    };

end