function yaxisreformat(varargin)
% yaxisreformat  Reformat the numeric ticks on the y axis.
%
% Syntax
% =======
%
%     yaxisreformat()
%     yaxisreformat(NEWFORMAT)
%     yaxisreformat(AX,NEWFORMAT)
%
% Input arguments
% ================
%
% * `NEWFORMAT` [ char ] - New `sprintf` format for the numeric ticks; if
% not specified, the format will be determined automatically depending on
% the y-axis tick step size.
%
% * `AX` [ numeric ] - Handle(s) to the axes that will be re-formatted.
%

%**************************************************************************

if ~isempty(varargin) && all(ishghandle(varargin{1}))
    AX = varargin{1};
    varargin(1) = [];
else
    AX = gca();
end

if ~isempty(varargin)
    format = varargin{1};
    varargin(1) = [];
else
    format = 'auto';
end

for ax = AX(:).'
    ytick = get(ax,'yTick');
    if isequal(format,'auto')
        d = max([0,-floor(log10(ytick(2)-ytick(1)))]);
        format = ['%.',sprintf('%g',d),'f'];
    end
    ytickstring = cell(size(ytick));
    for j = 1 : length(ytick)
        ytickstring{j} = sprintf(format,ytick(j));
    end
    set(ax,'yTickMode','manual', ...
        'yTickLabel',ytickstring,'yTickLabelMode','manual');
end

end