function h = ucircle(varargin)
% ucircle  Plot a unit circle with equal axes.
%
% Syntax
% =======
%
%     h = ucircle(...)
%
% Output arguments
% =================
%
% * `h` [ numeric ] - Handle to the unit circle line.
%
% Options
% ========
%
% Any property name-value pair valid for line graphs.
%
% Description
% ============
%
% Example
% ========
% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

h = grfun.plotcircle(0,0,1,varargin{:});
label = cellstr(get(gca,'yticklabel'));
label = regexprep(label,'\s*([\+-\.\d]+).*','$1 i');
set(gca,'yticklabel',label,'ytickmode','manual');
axis('equal');
axis('square');

end
