function D = psf2sdf(S,C)
% psf2sdf  Convert power spectrum to spectral density.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

D = S;
realsmall = getrealsmall();
nalt = size(S,4);

for ialt = 1 : nalt
   Dk = S(:,:,:,ialt);
   aux = diag(C(:,:,1,ialt));
   nonzero = abs(aux) > realsmall;
   aux(nonzero) = 1./sqrt(aux(nonzero));
   X = aux(:,ones([1,size(aux,1)]));
   X = X.*transpose(X);
   index = isinf(Dk(:,:,:));
   Dk(index) = 0;
   for i = 1 : size(Dk,3)
      Dk(:,:,i) = X.*Dk(:,:,i);
   end
   Dk(index) = NaN;
   D(:,:,:,ialt) = Dk;
end

end
