function stdcorr = cov2stdcorr(Omg,varargin)
% COV2STDCORR  [Not a public function] Convert cov matrix to stdcorr vector.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************
    
    [ans,ne,nper,nalt] = size(Omg); %#ok<NOANS,ASGLU>
    Omg = Omg(:,:,:);
    
    index = tril(ones(ne),-1) == 1;
    R = covfun.cov2corr(Omg);
    n = ne + ne*(ne-1)/2;
    stdcorr = nan(n,nper*nalt);
    for i = 1 : nper*nalt
        stdcorr(1:ne,i) = sqrt(diag(Omg(:,:,i)));
        stdcorr(ne+1:end,i) = R(index);
    end

    stdcorr = reshape(stdcorr,[n,nper,nalt]);
    
end