function [X,y0,k,y1,g1] = sumofcoeff(mu,varargin)
% sumofcoeff  Doan et al sum-of-coefficient prior dummy observations for BVARs.
%
% Syntax
% =======
%
%     [X,Y0,K,Y1,G1] = BVAR.sumofcoeff(MU,[NY,P])
%     [X,Y0,K,Y1,G1] = BVAR.sumofcoeff(MU,[NY,P,NG])
%
% Input arguments
% ================
%
% * `MU` [ numeric ] - Weight on the dummy observations.
%
% * `[NY,P,NG]` [ numeric ] - Number of variables, order of the VAR, and
% number of co-integrating vectors in the VAR for which the prior dummies
% will be created.
%
% Output arguments
% =================
%
% * `X` [ numeric ] - Array with prior dummy observations that can be used
% in the `'BVAR='` option of the [`VAR/estimate`](VAR/estimate) function.
%
% * `Y0`, `K`, `Y1`, `G1` [ numeric ] - These extra output arguments only
% provide more details on the structure of the dummy observations, and have
% no use; `X=[Y0;K;Y1;G1]`.
%
% Description
% ============
%
% Example
% ========
%

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

ng = 0;
if length(varargin) == 1
   % BVAR.sumofcoeff(mu,[ny,p]);
   ny = varargin{1}(1);
   p = varargin{1}(2);
   if length(varargin{1}) > 2
       ng = varargin{1}(3);
   end
else
   % Bkw compatibility.
   % BVAR.sumofcoeff(mu,ny,p);
   ny = varargin{1};
   p = varargin{2};
   if length(varargin) > 2
      ng = varargin{3};
   end
end

P = inputParser();
P.addRequired('ny',@isnumericscalar);
P.addRequired('p',@isnumericscalar);
P.addRequired('ng',@isnumericscalar);
P.addRequired('mu',@isnumericscalar);
P.parse(ny,p,ng,mu);

%********************************************************************

nd = ny;
k = zeros([1,nd]);
g1 = zeros([ng,nd]);
y0 = eye(ny);
y1 = repmat(y0,[p,1]);
y0 = y0*mu;
y1 = y1*mu;
X = [y0;k;y1;g1];

end
