% BVAR  Bayesian VAR prior dummies: BVAR package.
%
% The BVAR package can be used to create the basic types of prior dummy
% observations when estimating Bayesian VAR models. The dummy observations
% are passed in the [`VAR/estimate`](VAR/estimate) function through the
% `'BVAR='` option.
%
% Constructing dummy observations
% ================================
%
% * [`litterman`](BVAR/litterman) - Litterman's prior dummy observations for BVARs.
% * [`sumofcoeff`](BVAR/sumofcoeff) - Doan et al sum-of-coefficient prior dummy observations for BVARs.
% * [`uncmean`](BVAR/uncmean) - Unconditional-mean dummy (or Sims' initial dummy) observations for BVARs.
%
% Getting help on BVAR functions
% ===============================
%
%     help BVAR
%     help BVAR/function_name
%

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.