%Comparison of alternative modes of seasonal adjustment
clear
clc
close all
addpath(fullfile(cd, '/iris'))
addpath(fullfile(cd, '/ssm'))
irisstartup

m=xlsread('bls2.xls','nsa','B3:EW282');
jstr={'AE1011330000.spc','AE1021100000.spc','CO1021210000.spc','CO1021220000.spc','CO1021230000.spc','AE1021300000.spc','CO2023611500.spc','CO2023611600.spc','CO2023611700.spc','CO2023611800.spc','CO2023621000.spc','CO2023622000.spc','AE2023700000.spc','CO2023811000.spc','CO2023812000.spc','CO2023813000.spc','CO2023814000.spc','CO2023815000.spc','CO2023816000.spc','CO2023817000.spc','CO2023819000.spc','CO2023821000.spc','CO2023822000.spc','CO2023829000.spc','CO2023831000.spc','CO2023832000.spc','CO2023833000.spc','CO2023834000.spc','CO2023835000.spc','CO2023839000.spc','CO2023891000.spc','CO2023899000.spc','AE3132100000.spc','AE3132700000.spc','AE3133100000.spc','AE3133200000.spc','AE3133300000.spc','CO3133410000.spc','CO3133420000.spc','CO3133430000.spc','CO3133440000.spc','CO3133450000.spc','CO3133460000.spc','AE3133500000.spc','AE3133600000.spc','AE3133700000.spc','AE3133900000.spc','AE3231100000.spc','AE3231300000.spc','AE3231400000.spc','AE3231500000.spc','AE3232200000.spc','AE3232300000.spc','AE3232400000.spc','AE3232500000.spc','AE3232600000.spc','AE3232900000.spc','AE4142300000.spc','AE4142400000.spc','AE4142500000.spc','CO4244110000.spc','CO4244120000.spc','CO4244130000.spc','AE4244200000.spc','AE4244300000.spc','AE4244400000.spc','AE4244500000.spc','AE4244600000.spc','AE4244700000.spc','AE4244800000.spc','AE4245100000.spc','CO4245210000.spc','CO4245290000.spc','AE4245300000.spc','AE4245400000.spc','AE4348100000.spc','AE4348200000.spc','AE4348300000.spc','AE4348400000.spc','AE4348500000.spc','AE4348600000.spc','AE4348700000.spc','AE4348800000.spc','AE4349200000.spc','AE4349300000.spc','AE4422000000.spc','AE5051100000.spc','AE5051200000.spc','AE5051500000.spc','AE5051700000.spc','AE5051800000.spc','AE5051900000.spc','AE5552100000.spc','CO5552210000.spc','CO5552220000.spc','CO5552230000.spc','AE5552300000.spc','AE5552400000.spc','AE5552500000.spc','AE5553100000.spc','AE5553200000.spc','AE5553300000.spc','CO6054110000.spc','CO6054120000.spc','CO6054130000.spc','CO6054140000.spc','CO6054150000.spc','CO6054160000.spc','CO6054170000.spc','CO6054180000.spc','CO6054190000.spc','AE6055000000.spc','CO6056110000.spc','CO6056120000.spc','CO6056130000.spc','CO6056140000.spc','CO6056150000.spc','CO6056160000.spc','CO6056170000.spc','CO6056190000.spc','AE6056200000.spc','AE6561000000.spc','CO6562110000.spc','CO6562120000.spc','CO6562130000.spc','CO6562140000.spc','CO6562150000.spc','CO6562160000.spc','CO6562190000.spc','AE6562200000.spc','CO6562310000.spc','CO6562320000.spc','CO6562330000.spc','CO6562390000.spc','CO6562410000.spc','CO6562420000.spc','CO6562430000.spc','CO6562440000.spc','AE7071100000.spc','AE7071200000.spc','AE7071300000.spc','AE7072100000.spc','AE7072200000.spc','AE8081100000.spc','AE8081200000.spc','AE8081300000.spc','AE9091100000.spc','AE9091912000.spc','AE9092161100.spc','AE9092200000.spc','AE9093161100.spc','AE9093200000.spc'};
mstr={'v_default','v_3x1','v_3x3','v_3x5','v_3x9','v_3x15','v_stable'};
nmstr=length(mstr)+3;
m_m=sum(m')';
[bigt,n]=size(m);
h=[1;6;12];

for k=1:nmstr;
    disp(k);
    for i=121:bigt-12;
        for j=1:n;
            if i==121; x=tseries(mm(1990,1):mm(2000,1),m(1:i,j)); end;
            if i==122; x=tseries(mm(1990,1):mm(2000,2),m(1:i,j)); end;
            if i==123; x=tseries(mm(1990,1):mm(2000,3),m(1:i,j)); end;
            if i==124; x=tseries(mm(1990,1):mm(2000,4),m(1:i,j)); end;
            if i==125; x=tseries(mm(1990,1):mm(2000,5),m(1:i,j)); end;
            if i==126; x=tseries(mm(1990,1):mm(2000,6),m(1:i,j)); end;
            if i==127; x=tseries(mm(1990,1):mm(2000,7),m(1:i,j)); end;
            if i==128; x=tseries(mm(1990,1):mm(2000,8),m(1:i,j)); end;
            if i==129; x=tseries(mm(1990,1):mm(2000,9),m(1:i,j)); end;
            if i==130; x=tseries(mm(1990,1):mm(2000,10),m(1:i,j)); end;
            if i==131; x=tseries(mm(1990,1):mm(2000,11),m(1:i,j)); end;
            if i==132; x=tseries(mm(1990,1):mm(2000,12),m(1:i,j)); end;
            if i==133; x=tseries(mm(1990,1):mm(2001,1),m(1:i,j)); end;
            if i==134; x=tseries(mm(1990,1):mm(2001,2),m(1:i,j)); end;
            if i==135; x=tseries(mm(1990,1):mm(2001,3),m(1:i,j)); end;
            if i==136; x=tseries(mm(1990,1):mm(2001,4),m(1:i,j)); end;
            if i==137; x=tseries(mm(1990,1):mm(2001,5),m(1:i,j)); end;
            if i==138; x=tseries(mm(1990,1):mm(2001,6),m(1:i,j)); end;
            if i==139; x=tseries(mm(1990,1):mm(2001,7),m(1:i,j)); end;
            if i==140; x=tseries(mm(1990,1):mm(2001,8),m(1:i,j)); end;
            if i==141; x=tseries(mm(1990,1):mm(2001,9),m(1:i,j)); end;
            if i==142; x=tseries(mm(1990,1):mm(2001,10),m(1:i,j)); end;
            if i==143; x=tseries(mm(1990,1):mm(2001,11),m(1:i,j)); end;
            if i==144; x=tseries(mm(1990,1):mm(2001,12),m(1:i,j)); end;
            if i==145; x=tseries(mm(1990,1):mm(2002,1),m(1:i,j)); end;
            if i==146; x=tseries(mm(1990,1):mm(2002,2),m(1:i,j)); end;
            if i==147; x=tseries(mm(1990,1):mm(2002,3),m(1:i,j)); end;
            if i==148; x=tseries(mm(1990,1):mm(2002,4),m(1:i,j)); end;
            if i==149; x=tseries(mm(1990,1):mm(2002,5),m(1:i,j)); end;
            if i==150; x=tseries(mm(1990,1):mm(2002,6),m(1:i,j)); end;
            if i==151; x=tseries(mm(1990,1):mm(2002,7),m(1:i,j)); end;
            if i==152; x=tseries(mm(1990,1):mm(2002,8),m(1:i,j)); end;
            if i==153; x=tseries(mm(1990,1):mm(2002,9),m(1:i,j)); end;
            if i==154; x=tseries(mm(1990,1):mm(2002,10),m(1:i,j)); end;
            if i==155; x=tseries(mm(1990,1):mm(2002,11),m(1:i,j)); end;
            if i==156; x=tseries(mm(1990,1):mm(2002,12),m(1:i,j)); end;
            if i==157; x=tseries(mm(1990,1):mm(2003,1),m(1:i,j)); end;
            if i==158; x=tseries(mm(1990,1):mm(2003,2),m(1:i,j)); end;
            if i==159; x=tseries(mm(1990,1):mm(2003,3),m(1:i,j)); end;
            if i==160; x=tseries(mm(1990,1):mm(2003,4),m(1:i,j)); end;
            if i==161; x=tseries(mm(1990,1):mm(2003,5),m(1:i,j)); end;
            if i==162; x=tseries(mm(1990,1):mm(2003,6),m(1:i,j)); end;
            if i==163; x=tseries(mm(1990,1):mm(2003,7),m(1:i,j)); end;
            if i==164; x=tseries(mm(1990,1):mm(2003,8),m(1:i,j)); end;
            if i==165; x=tseries(mm(1990,1):mm(2003,9),m(1:i,j)); end;
            if i==166; x=tseries(mm(1990,1):mm(2003,10),m(1:i,j)); end;
            if i==167; x=tseries(mm(1990,1):mm(2003,11),m(1:i,j)); end;
            if i==168; x=tseries(mm(1990,1):mm(2003,12),m(1:i,j)); end;
            if i==169; x=tseries(mm(1990,1):mm(2004,1),m(1:i,j)); end;
            if i==170; x=tseries(mm(1990,1):mm(2004,2),m(1:i,j)); end;
            if i==171; x=tseries(mm(1990,1):mm(2004,3),m(1:i,j)); end;
            if i==172; x=tseries(mm(1990,1):mm(2004,4),m(1:i,j)); end;
            if i==173; x=tseries(mm(1990,1):mm(2004,5),m(1:i,j)); end;
            if i==174; x=tseries(mm(1990,1):mm(2004,6),m(1:i,j)); end;
            if i==175; x=tseries(mm(1990,1):mm(2004,7),m(1:i,j)); end;
            if i==176; x=tseries(mm(1990,1):mm(2004,8),m(1:i,j)); end;
            if i==177; x=tseries(mm(1990,1):mm(2004,9),m(1:i,j)); end;
            if i==178; x=tseries(mm(1990,1):mm(2004,10),m(1:i,j)); end;
            if i==179; x=tseries(mm(1990,1):mm(2004,11),m(1:i,j)); end;
            if i==180; x=tseries(mm(1990,1):mm(2004,12),m(1:i,j)); end;
            if i==181; x=tseries(mm(1990,1):mm(2005,1),m(1:i,j)); end;
            if i==182; x=tseries(mm(1990,1):mm(2005,2),m(1:i,j)); end;
            if i==183; x=tseries(mm(1990,1):mm(2005,3),m(1:i,j)); end;
            if i==184; x=tseries(mm(1990,1):mm(2005,4),m(1:i,j)); end;
            if i==185; x=tseries(mm(1990,1):mm(2005,5),m(1:i,j)); end;
            if i==186; x=tseries(mm(1990,1):mm(2005,6),m(1:i,j)); end;
            if i==187; x=tseries(mm(1990,1):mm(2005,7),m(1:i,j)); end;
            if i==188; x=tseries(mm(1990,1):mm(2005,8),m(1:i,j)); end;
            if i==189; x=tseries(mm(1990,1):mm(2005,9),m(1:i,j)); end;
            if i==190; x=tseries(mm(1990,1):mm(2005,10),m(1:i,j)); end;
            if i==191; x=tseries(mm(1990,1):mm(2005,11),m(1:i,j)); end;
            if i==192; x=tseries(mm(1990,1):mm(2005,12),m(1:i,j)); end;
            if i==193; x=tseries(mm(1990,1):mm(2006,1),m(1:i,j)); end;
            if i==194; x=tseries(mm(1990,1):mm(2006,2),m(1:i,j)); end;
            if i==195; x=tseries(mm(1990,1):mm(2006,3),m(1:i,j)); end;
            if i==196; x=tseries(mm(1990,1):mm(2006,4),m(1:i,j)); end;
            if i==197; x=tseries(mm(1990,1):mm(2006,5),m(1:i,j)); end;
            if i==198; x=tseries(mm(1990,1):mm(2006,6),m(1:i,j)); end;
            if i==199; x=tseries(mm(1990,1):mm(2006,7),m(1:i,j)); end;
            if i==200; x=tseries(mm(1990,1):mm(2006,8),m(1:i,j)); end;
            if i==201; x=tseries(mm(1990,1):mm(2006,9),m(1:i,j)); end;
            if i==202; x=tseries(mm(1990,1):mm(2006,10),m(1:i,j)); end;
            if i==203; x=tseries(mm(1990,1):mm(2006,11),m(1:i,j)); end;
            if i==204; x=tseries(mm(1990,1):mm(2006,12),m(1:i,j)); end;
            if i==205; x=tseries(mm(1990,1):mm(2007,1),m(1:i,j)); end;
            if i==206; x=tseries(mm(1990,1):mm(2007,2),m(1:i,j)); end;
            if i==207; x=tseries(mm(1990,1):mm(2007,3),m(1:i,j)); end;
            if i==208; x=tseries(mm(1990,1):mm(2007,4),m(1:i,j)); end;
            if i==209; x=tseries(mm(1990,1):mm(2007,5),m(1:i,j)); end;
            if i==210; x=tseries(mm(1990,1):mm(2007,6),m(1:i,j)); end;
            if i==211; x=tseries(mm(1990,1):mm(2007,7),m(1:i,j)); end;
            if i==212; x=tseries(mm(1990,1):mm(2007,8),m(1:i,j)); end;
            if i==213; x=tseries(mm(1990,1):mm(2007,9),m(1:i,j)); end;
            if i==214; x=tseries(mm(1990,1):mm(2007,10),m(1:i,j)); end;
            if i==215; x=tseries(mm(1990,1):mm(2007,11),m(1:i,j)); end;
            if i==216; x=tseries(mm(1990,1):mm(2007,12),m(1:i,j)); end;
            if i==217; x=tseries(mm(1990,1):mm(2008,1),m(1:i,j)); end;
            if i==218; x=tseries(mm(1990,1):mm(2008,2),m(1:i,j)); end;
            if i==219; x=tseries(mm(1990,1):mm(2008,3),m(1:i,j)); end;
            if i==220; x=tseries(mm(1990,1):mm(2008,4),m(1:i,j)); end;
            if i==221; x=tseries(mm(1990,1):mm(2008,5),m(1:i,j)); end;
            if i==222; x=tseries(mm(1990,1):mm(2008,6),m(1:i,j)); end;
            if i==223; x=tseries(mm(1990,1):mm(2008,7),m(1:i,j)); end;
            if i==224; x=tseries(mm(1990,1):mm(2008,8),m(1:i,j)); end;
            if i==225; x=tseries(mm(1990,1):mm(2008,9),m(1:i,j)); end;
            if i==226; x=tseries(mm(1990,1):mm(2008,10),m(1:i,j)); end;
            if i==227; x=tseries(mm(1990,1):mm(2008,11),m(1:i,j)); end;
            if i==228; x=tseries(mm(1990,1):mm(2008,12),m(1:i,j)); end;
            if i==229; x=tseries(mm(1990,1):mm(2009,1),m(1:i,j)); end;
            if i==230; x=tseries(mm(1990,1):mm(2009,2),m(1:i,j)); end;
            if i==231; x=tseries(mm(1990,1):mm(2009,3),m(1:i,j)); end;
            if i==232; x=tseries(mm(1990,1):mm(2009,4),m(1:i,j)); end;
            if i==233; x=tseries(mm(1990,1):mm(2009,5),m(1:i,j)); end;
            if i==234; x=tseries(mm(1990,1):mm(2009,6),m(1:i,j)); end;
            if i==235; x=tseries(mm(1990,1):mm(2009,7),m(1:i,j)); end;
            if i==236; x=tseries(mm(1990,1):mm(2009,8),m(1:i,j)); end;
            if i==237; x=tseries(mm(1990,1):mm(2009,9),m(1:i,j)); end;
            if i==238; x=tseries(mm(1990,1):mm(2009,10),m(1:i,j)); end;
            if i==239; x=tseries(mm(1990,1):mm(2009,11),m(1:i,j)); end;
            if i==240; x=tseries(mm(1990,1):mm(2009,12),m(1:i,j)); end;
            if i==241; x=tseries(mm(1990,1):mm(2010,1),m(1:i,j)); end;
            if i==242; x=tseries(mm(1990,1):mm(2010,2),m(1:i,j)); end;
            if i==243; x=tseries(mm(1990,1):mm(2010,3),m(1:i,j)); end;
            if i==244; x=tseries(mm(1990,1):mm(2010,4),m(1:i,j)); end;
            if i==245; x=tseries(mm(1990,1):mm(2010,5),m(1:i,j)); end;
            if i==246; x=tseries(mm(1990,1):mm(2010,6),m(1:i,j)); end;
            if i==247; x=tseries(mm(1990,1):mm(2010,7),m(1:i,j)); end;
            if i==248; x=tseries(mm(1990,1):mm(2010,8),m(1:i,j)); end;
            if i==249; x=tseries(mm(1990,1):mm(2010,9),m(1:i,j)); end;
            if i==250; x=tseries(mm(1990,1):mm(2010,10),m(1:i,j)); end;
            if i==251; x=tseries(mm(1990,1):mm(2010,11),m(1:i,j)); end;
            if i==252; x=tseries(mm(1990,1):mm(2010,12),m(1:i,j)); end;
            if i==253; x=tseries(mm(1990,1):mm(2011,1),m(1:i,j)); end;
            if i==254; x=tseries(mm(1990,1):mm(2011,2),m(1:i,j)); end;
            if i==255; x=tseries(mm(1990,1):mm(2011,3),m(1:i,j)); end;
            if i==256; x=tseries(mm(1990,1):mm(2011,4),m(1:i,j)); end;
            if i==257; x=tseries(mm(1990,1):mm(2011,5),m(1:i,j)); end;
            if i==258; x=tseries(mm(1990,1):mm(2011,6),m(1:i,j)); end;
            if i==259; x=tseries(mm(1990,1):mm(2011,7),m(1:i,j)); end;
            if i==260; x=tseries(mm(1990,1):mm(2011,8),m(1:i,j)); end;
            if i==261; x=tseries(mm(1990,1):mm(2011,9),m(1:i,j)); end;
            if i==262; x=tseries(mm(1990,1):mm(2011,10),m(1:i,j)); end;
            if i==263; x=tseries(mm(1990,1):mm(2011,11),m(1:i,j)); end;
            if i==264; x=tseries(mm(1990,1):mm(2011,12),m(1:i,j)); end;
            if i==265; x=tseries(mm(1990,1):mm(2012,1),m(1:i,j)); end;
            if i==266; x=tseries(mm(1990,1):mm(2012,2),m(1:i,j)); end;
            if i==267; x=tseries(mm(1990,1):mm(2012,3),m(1:i,j)); end;
            if i==268; x=tseries(mm(1990,1):mm(2012,4),m(1:i,j)); end;
            if k<=2; 
                xsa=x; 
                x=double(x);
                xsa=double(xsa);
            end;
            if k==3;
                x=double(x);
                stsm = ssm_stsm('trend', 'dummy', 12);
                [stsm logL] = estimate(x', stsm, 0.01, [], 'maxiter', 10000, 'disp', 'off');
                [alpha irr] = fastsmo(x', stsm);
                ycom        = signal(alpha, stsm);
                xsa         = x-ycom(2, :)';
            end;
            if k>3;
                cd(char(mstr(k-3)));  
                xsa=x12(x,Inf,'specfile=',char(jstr(j)));
                cd ..
                x=double(x);
                xsa=double(xsa);
            end;
            mnsa(:,j)=x;
            msa(:,j)=xsa;
            p=bicpic(log(xsa));
            if k==2;
                fa(i-120,j)=arforcd(log(xsa),p,h(1));
                fb(i-120,j)=arforcd(log(xsa),p,h(2));
                fc(i-120,j)=arforcd(log(xsa),p,h(3));
            else;
                fa(i-120,j)=arforc(log(xsa),p,h(1))+log(x(end-12+h(1)))-log(x(end))-log(xsa(end-12+h(1)))+log(xsa(end));
                fb(i-120,j)=arforc(log(xsa),p,h(2))+log(x(end-12+h(2)))-log(x(end))-log(xsa(end-12+h(2)))+log(xsa(end));
                fc(i-120,j)=arforc(log(xsa),p,h(3))+log(x(end-12+h(3)))-log(x(end))-log(xsa(end-12+h(3)))+log(xsa(end));
            end;
            oa(i-120,j)=log(m(i+h(1),j))-log(m(i,j));
            ob(i-120,j)=log(m(i+h(2),j))-log(m(i,j));
            oc(i-120,j)=log(m(i+h(3),j))-log(m(i,j));
        end;
        msa_m=sum(msa')';
        mnsa_m=sum(mnsa')';
        p=bicpic(log(msa_m));
        if k==2;
            fa(i-120,n+1)=arforcd(log(msa_m),p,h(1));
            fb(i-120,n+1)=arforcd(log(msa_m),p,h(2));
            fc(i-120,n+1)=arforcd(log(msa_m),p,h(3));
        else;
            fa(i-120,n+1)=arforc(log(msa_m),p,h(1))+log(mnsa_m(end-12+h(1)))-log(mnsa_m(end))-log(msa_m(end-12+h(1)))+log(msa_m(end));
            fb(i-120,n+1)=arforc(log(msa_m),p,h(2))+log(mnsa_m(end-12+h(2)))-log(mnsa_m(end))-log(msa_m(end-12+h(2)))+log(msa_m(end));
            fc(i-120,n+1)=arforc(log(msa_m),p,h(3))+log(mnsa_m(end-12+h(3)))-log(mnsa_m(end))-log(msa_m(end-12+h(3)))+log(msa_m(end));
        end;
        if k==2; %FAAR
            fa(i-120,n+2)=faard(log(msa_m),log(msa),h(1),3,p);
            fb(i-120,n+2)=faard(log(msa_m),log(msa),h(2),3,p);
            fc(i-120,n+2)=faard(log(msa_m),log(msa),h(3),3,p);
        else;
            fa(i-120,n+2)=faar(log(msa_m),log(msa),h(1),3,p)+log(mnsa_m(end-12+h(1)))-log(mnsa_m(end))-log(msa_m(end-12+h(1)))+log(msa_m(end));  
            fb(i-120,n+2)=faar(log(msa_m),log(msa),h(2),3,p)+log(mnsa_m(end-12+h(2)))-log(mnsa_m(end))-log(msa_m(end-12+h(2)))+log(msa_m(end));  
            fc(i-120,n+2)=faar(log(msa_m),log(msa),h(3),3,p)+log(mnsa_m(end-12+h(3)))-log(mnsa_m(end))-log(msa_m(end-12+h(3)))+log(msa_m(end));  
        end;
        clear msa mnsa;
        oa(i-120,n+1)=log(m_m(i+h(1),1))-log(m_m(i,1));  %Actual outcomes
        ob(i-120,n+1)=log(m_m(i+h(2),1))-log(m_m(i,1));  
        oc(i-120,n+1)=log(m_m(i+h(3),1))-log(m_m(i,1));  
        oa(i-120,n+2)=log(m_m(i+h(1),1))-log(m_m(i,1)); 
        ob(i-120,n+2)=log(m_m(i+h(2),1))-log(m_m(i,1));  
        oc(i-120,n+2)=log(m_m(i+h(3),1))-log(m_m(i,1));  
    end;
    ffa(:,:,k)=fa; ffb(:,:,k)=fb; ffc(:,:,k)=fc;
    rmsea(k,:)=sqrt(mean((fa-oa).^2));
    rmseb(k,:)=sqrt(mean((fb-ob).^2));
    rmsec(k,:)=sqrt(mean((fc-oc).^2));
end;

irisfinish;

imc=1;
for k1=1:nmstr;
    for k2=k1+1:nmstr;
        for j=1:n+2; 
            dmstata(imc,j)=dmtstat(oa(:,j)-squeeze(ffa(:,j,k1)),oa(:,j)-squeeze(ffa(:,j,k2)),0); 
            dmstatb(imc,j)=dmtstat(ob(:,j)-squeeze(ffb(:,j,k1)),ob(:,j)-squeeze(ffb(:,j,k2)),0); 
            dmstatc(imc,j)=dmtstat(oc(:,j)-squeeze(ffc(:,j,k1)),oc(:,j)-squeeze(ffc(:,j,k2)),0); 
        end;
        imc=imc+1;
    end;
end;



disp('Table 1');
disp('RMSE of Total Payrolls');
disp('Order: NSA/NSA+Dum/Model/Default/3x1/3x3/3x5/3x9/3x15/stable');
disp(100*[rmsea(:,153) rmseb(:,153) rmsec(:,153)]);
disp('DM Stats: P-values');
dmstata=2*normcdf(-abs(dmstata));
dmstatb=2*normcdf(-abs(dmstatb));
dmstatc=2*normcdf(-abs(dmstatc));
disp('NSA v. NSA+Dum/Model/Default/3x1/3x3/3x5/3x9/3x15/stable');
disp([dmstata(1:9,153) dmstatb(1:9,153) dmstatc(1:9,153)]);
disp('Model v. Default');
disp([dmstata(18,153) dmstatb(18,153) dmstatc(18,153)]);
disp('Default v. 3x1/3x3/3x5/3x9/3x15/stable');
disp([dmstata(25:30,153) dmstatb(25:30,153) dmstatc(25:30,153)]);
disp('3x1 v. stable');
disp([dmstata(35,153) dmstatb(35,153) dmstatc(35,153)]);

disp('Table 2');
[q,w]=min(rmsea(3:10,1:152));
e(:,1)=[sum(w==1);sum(w==2);sum(w==3);sum(w==4);sum(w==5);sum(w==6);sum(w==7);sum(w==8)];
[q,w]=min(rmseb(3:10,1:152));
e(:,2)=[sum(w==1);sum(w==2);sum(w==3);sum(w==4);sum(w==5);sum(w==6);sum(w==7);sum(w==8)];
[q,w]=min(rmsec(3:10,1:152));
e(:,3)=[sum(w==1);sum(w==2);sum(w==3);sum(w==4);sum(w==5);sum(w==6);sum(w==7);sum(w==8)];
disp('Number of series for which optimal filter is: Model/Default/3x1/3x3/3x5/3x9/3x15/stable');
disp(e);

disp('Table 3');
disp('FAAR: RMSE of Total Payrolls');
disp(100*[rmsea(:,154) rmseb(:,154) rmsec(:,154)]);
disp('DM Stats: P-values');
disp('NSA v. NSA+Dum/Model/Default/3x1/3x3/3x5/3x9/3x15/stable');
disp([dmstata(1:9,154) dmstatb(1:9,154) dmstatc(1:9,154)]);
disp('Model v. Default');
disp([dmstata(18,154) dmstatb(18,154) dmstatc(18,154)]);
disp('Default v. 3x1/3x3/3x5/3x9/3x15/stable');
disp([dmstata(25:30,154) dmstatb(25:30,154) dmstatc(25:30,154)]);
disp('3x1 v. stable');
disp([dmstata(35,154) dmstatb(35,154) dmstatc(35,154)]);
