function r = randsn(dim,Ex,Sx,tau)
% randsn  Split-normally distributed random numbers.

% The IRIS Toolbox.
% Copyright 2007-2009 Jaromir Benes.

%**************************************************************************

[ans,mu,sigma] = snormpdf([],Ex,Sx,tau);

r = sigma*randn(dim);
index = rand(dim) <= 1/(1 + tau);
r(index) = -abs(r(index));
r(~index) = tau*abs(r(~index));
r = r + mu;

end