function [X,Z] = randnlatin(P,N)
% randnlatin  Latin hypercube sample from standard normal distribution.

X = randn(P,N);
if nargout > 1
    Z = X;
end

for i = 1 : P
   X(i,:) = xxrank(X(i,:));
end

X = X - rand(size(X));
X = X / N;
X = xxnorminv(X);

end

%**************************************************************************
function r = xxrank(x)
x = x(:);
[~,rowidx] = sort(x);
r(rowidx) = 1 : length(x);
r = r(:);
end
% xxrank().

%**************************************************************************
function x = xxnorminv(p)
x = -sqrt(2).*erfcinv(2*p);
end
% xxnorminv().