function [c,n] = irisversion()
% irisversion  Current IRIS version.
%
% Syntax
% =======
%
%     irisversion
%     X = irisversion()
%
% Output arguments
% =================
%
% *`X` [ char ] - String describing the currently installed IRIS version.
%
% Description
% ============
%
% The version string consists of the generation number, followed by a dot
% and the distribution date (yyyymmdd).
%
% The `irisversion` function is equivalent to the following call to
% [`irisget`](config/irisget)
%
%     irisget('version')
%

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

% IRIS version is permanently stored in the root Contents.m file, and is
% accessible through the Matlab ver() command. In each session, the version
% is refreshed by the `irisconfig` file.

c = irisconfigmaster('get','version');
if nargout > 1
    n = str2double(c);
end

end