function irisrequired(min)
% irisrequired  Throw error if the installed version of IRIS fails to comply with the required minimum.
%
% Syntax
% =======
%
%     irisrequired(V)
%
% Input arguments
% ================
%
% * `V` [ char ] - Text string describing the oldest acceptable
% distribution of IRIS.
%
% Description
% ============
%
% If the version of IRIS present on the computer does not comply with the
% minimum requirement `v`, an error is thrown.
%
% Example
% ========
%
% All of the three calls are valid:
%
%     irisrequired(20111222);
%     irisrequired('20111222');
%     irisrequired 20111222;
%

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

if ischar(min)
    min = str2double(min);
end

[vchar,vnum] = irisversion();

if vnum < min
    if round(min) == min
        dec = 0;
    else
        dec = 8;
    end
    utils.error('config', ...
        ['IRIS Toolbox %.*f or later is required. ', ...
        'Your current version is %s.'],dec,min,vchar);
end

end