function dbprintuserdata(d,varargin)
% dbprintuserdata  Print names of database tseries along with specified fields of their userdata.
%
% Syntax
% =======
%
%     dbprintuserdata(D,FIELD1,FIELD2,...)
%
% Input arguments
% ================
%
% * `D` [ struct ] - Database whose tseries objects will be reported.
%
% * `FIELD1`, `FIELD2`, ... [ char ] - Names of the userdata fields whose
% content (if char) will reported.
%
% Description
% ============
%
% Example
% ========

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

list = fieldnames(d);
n = max(cellfun(@length,list));
for i = 1 : length(list)
    name = list{i};
    fprintf('\t%*s',n,name);
    u = userdata(d.(name));
    for j = 1 : length(varargin)
        field = varargin{j};
        try
            if field(1) == '.'
                field(1) = '';
            end
            value = u.(field);
        catch %#ok<CTCH>
            value = NaN;
        end
        if ischar(value)
            value = regexprep(value,':\s*',': ');
            value = regexprep(value,';\s*','; ');
            value = regexprep(value,',\s*',', ');
            value = strtrim(value);
            value = sprintf('"%s"',value);
        else
            value = '???';
        end
        if j > 1
            fprintf('\t%*s',n,' ');
        end
        fprintf('  .%s = %s',field,value);
        fprintf('\n');
    end
end

end