function [FF,AA,PDB] = dbplot(D,LIST,RANGE,varargin)
% dbplot  Plot from database.
%
% Syntax
% =======
%
%     [FF,AA,PDB] = dbplot(D,LIST,RANGE,...)
%     [FF,AA,PDB] = dbplot(D,RANGE,LIST,...)
%
% Input arguments
% ================
%
% * `D` [ struct ] - Database with input data.
%
% * `LIST` [ cellstr ] - List of expressions (or labelled expressions) that
% will be evaluated and plotted in separate graphs.
%
% * `RANGE` [ numeric ] - Date range.
%
% Output arguments
% =================
%
% * `FF` [ numeric ] - Handles to figures created by `qplot`.
%
% * `AA` [ cell ] - Handles to axes created by `qplot`.
%
% * `PDB` [ struct ] - Database with actually plotted series.
%
% Options
% ========
%
% * `'plotFunc='` [ @bar | @hist | *@plot* | @stem ] - Plot function used
% to create the graphs.
%
% See help on [`qreport/qplot`](qreport/qplot) for other options available.
%
% Description
% ============
%
% The function `dbplot` opens a new figure window (as many as needed to
% accommodate all graphs given the option `'subplot='`), and creates a
% graph for each entry in the cell array `LIST`.
%
% `LIST` can contain the names of the database time series, expression
% referring to the database fields evaluating to time series. You can also
% add labels (that will be displayed as graph titles) enclosed in double
% quotes and preceding the expressions. If you start the expression with a
% `^` (hat) symbol, the function specified in the `'transform='` option
% will not be applied to that expression.
%
% Example
% ========
%
%     dbplot(d,qq(2010,1):qq(2015,4),{'x','"Series Y" y','^"Series z"', ...
%        'transform=',@(x) 100*(x-1));
%

if isnumeric(LIST) && iscellstr(RANGE)
    [LIST,RANGE] = deal(RANGE,LIST);
end

%**************************************************************************

[FF,AA,PDB] = qreport.qreport(LIST,D,RANGE,'overflow=',true,varargin{:});

end