% dbase  Basic database management.
%
% Loading and saving databases
% =============================
%
% * [`dbload`](dbase/dbload) - Create database by loading CSV file.
% * [`dbsave`](dbase/dbsave) - Save database as CSV file.
%
% Getting information about databases
% ====================================
%
% * [`dbnames`](dbase/dbnames) - List of database entries filtered by name or class.
% * [`dbprintuserdata`](dbase/dbprintuserdata) - Print names of database tseries along with specified fields of their userdata.
% * [`dbrange`](dbase/dbrange) - Find a range that encompasses the ranges of the listed tseries objects.
% * [`dbsearchuserdata`](dbase/dbsearchuserdata) - Search database to find tseries by matching the content of their userdata fields.
% * [`dbuserdatalov`](dbase/dbuserdatalov) - List of values found in a specified user data field in tseries objects.
%
% Converting databases
% =====================
%
% * [`array2db`](dbase/array2db) - Convert numeric array to database.
% * [`db2array`](dbase/db2array) - Convert tseries database entries to numeric array.
% * [`db2tseries`](dbase/db2tseries) - Combine tseries database entries in one multivariate tseries object.
%
% Batch processing
% =================
%
% * [`dbbatch`](dbase/dbbatch) - Run a batch job within a database.
% * [`dbclip`](dbase/dbclip) - Clip all database tseries objects down to specified date range.
% * [`dbcol`](dbase/dbcol) - Retrieve the specified column or columns from database entries.
% * [`dbfun`](dbase/dbfun) - Apply function to each database field.
% * [`dbplot`](dbase/dbplot) - Plot from database.
% * [`dbredate`](dbase/dbredate) - Redate all tseries objects in a database.
%
% Combining databases
% ====================
%
% * [`dbextend`](dbase/dbextend) - Combine tseries observations from two or more databases.
% * [`dbmerge`](dbase/dbmerge) - Merge two or more databases.
% * [`dbminuscontrol`](dbase/dbminuscontrol) - Create simulation-minus-control database.
%
% Getting on-line help on database functions
% ===========================================
%
%     help dbase
%     help dbase/function_name
%


% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.
