function d = dateoy(d)
% dateoy  End of year for the specified daily date.
%
% Syntax
% =======
%
%     EOY = dateoy(D)
%
% Input arguments
% ================
%
% * `D` [ numeric ] - Daily serial date number.
%
% Output arguments
% =================
%
% * `EOY` [ numeric ] - Daily serial date number for the last day of the
% same year as `D`.
%
% Description
% ============
%
% Example
% ========
%

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

[y,m] = datevec(d); %#ok<NASGU>
d = datenum([y,12,eomday(y,12)]);

end