function d = dateoq(d)
% dateoq  End of quarter for the specified daily date.
%
% Syntax
% =======
%
%     EOQ = dateoq(D)
%
% Input arguments
% ================
%
% * `D` [ numeric ] - Daily serial date number.
%
% Output arguments
% =================
%
% * `EOQ` [ numeric ] - Daily serial date number for the last day of the
% same quarter as `D`.
%
% Description
% ============
%
% Example
% ========
%

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

[y,m] = datevec(d);
m = ceil(m/3);
d = datenum([y,m,eomday(y,m)]);

end