function d = dateom(d)
% dateom  End of month for the specified daily date.
%
% Syntax
% =======
%
%     EOM = dateom(D)
%
% Input arguments
% ================
%
% * `D` [ numeric ] - Daily serial date number.
%
% Output arguments
% =================
%
% * `EOM` [ numeric ] - Daily serial date number for the last day of the
% same month as `D`.
%
% Description
% ============
%
% Example
% ========
%

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

[y,m] = datevec(d);
d = datenum([y,m,eomday(y,m)]);

end