function flag = datcmp(d1,d2)
% datcmp  Compare two IRIS serial date numbers.
%
% Syntax
% =======
%
%     FLAG = datcmp(D1,D2)
%
% Input arguments
% ================
%
% * `D1`, `D2` [ numeric ] - IRIS serial date numbers or vectors.
%
% Output arguments
% =================
%
% * `FLAG` [ `true` | `false` ] - True for numbers that represent the same
% date.
%
% Description
% ============
%
% The two date vectors must either be the same lengths, or one of them must
% be scalar.
%
% Use this function instead of the plain comparison operator, `==`, to
% compare dates. The plain comparision can sometimes give false results
% because of round-off errors.
%
% Example
% ========
%
%     d1 = qq(2010,1);
%     d2 = qq(2009,1):qq(2010,4);
%     datcmp(d1,d2)
%     ans =
%         0     0     0     0     1     0     0     0

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

% Parse required input arguments.
P = inputParser();
P.addRequired('D1',@isnumeric);
P.addRequired('D2',@isnumeric);
P.parse(d1,d2);

%**************************************************************************

flag = abs(d1 - d2) < 0.01 | (isinf(d1) & isinf(d2));

end
