function d = datboy(d)
% datboy  Beginning of year for the specified daily date.
%
% Syntax
% =======
%
%     BOY = dateboy(D)
%
% Input arguments
% ================
%
% * `D` [ numeric ] - Daily serial date number.
%
% Output arguments
% =================
%
% * `BOY` [ numeric ] - Daily serial date number for the first day of the
% same year as `D`.
%
% Description
% ============
%
% Example
% ========
%

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

[y,m] = datevec(d); %#ok<NASGU>
d = datenum([y,1,1]);

end